% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{obs}
\alias{obs}
\title{Extracts the observations used for the estimation}
\usage{
obs(x)
}
\arguments{
\item{x}{A \code{fixest} object.}
}
\value{
It returns a simple vector of integers.
}
\description{
This function extracts the observations used in \code{fixest} estimation.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")
base$y[1:5] = NA

# Split sample estimations
est_split = feols(y ~ x1, base, split = ~species)
(obs_setosa = obs(est_split$setosa))
(obs_versi = obs(est_split$versicolor))

est_versi = feols(y ~ x1, base, subset = obs_versi)

etable(est_split, est_versi)




}
