% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_albert.R
\docType{data}
\name{college_recent_grads}
\alias{college_recent_grads}
\title{The Economic Guide To Picking A College Major}
\format{A data frame with 173 rows representing majors (recent graduates) and 21 variables:
\describe{
  \item{rank}{Rank by median earnings}
  \item{major_code}{Major code, FO1DP in ACS PUMS}
  \item{major}{Major description}
  \item{major_category}{Category of major from Carnevale et al}
  \item{total}{Total number of people with major}
  \item{sample_size}{Sample size (unweighted) of full-time, year-round ONLY (used for earnings)}
  \item{men}{Men with major}
  \item{women}{Women with major}
  \item{sharewomen}{Proportion women}
  \item{employed}{Number employed (ESR == 1 or 2)}
  \item{employed_fulltime}{Employed 35 hours or more}
  \item{employed_parttime}{Employed less than 35 hours}
  \item{employed_fulltime_yearround}{Employed at least 50 weeks (WKW == 1) and at least 35 hours (WKHP >= 35)}
  \item{unemployed}{Number unemployed (ESR == 3)}
  \item{unemployment_rate}{Unemployed / (Unemployed + Employed)}
  \item{p25th}{25th percentile of earnigns}
  \item{median}{Median earnings of full-time, year-round workers}
  \item{p75th}{75th percentile of earnings}
  \item{college_jobs}{Number with job requiring a college degree}
  \item{non_college_jobs}{Number with job not requiring a college degree}
  \item{low_wage_jobs}{Number in low-wage service jobs}
}}
\source{
See \url{https://github.com/fivethirtyeight/data/blob/master/college-majors/readme.md}. Note that
\code{women-stem.csv} was a subset of the original \code{recent-grads.csv}, so no data frame was created.
}
\usage{
college_recent_grads
}
\description{
The raw data behind the story
"The Economic Guide To Picking A College Major"
\url{http://fivethirtyeight.com/features/the-economic-guide-to-picking-a-college-major/}.
}
\seealso{
\code{\link{college_grad_students}}, \code{\link{college_all_ages}}
}
\keyword{datasets}
