% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct.R
\name{unpack}
\alias{unpack}
\title{Read and unpack bytes from a binary file connection}
\usage{
unpack(fmt, conn, endianness = "little", n = 1, ...)
}
\arguments{
\item{fmt}{a format character according to
\href{https://docs.python.org/3.5/library/struct.html}{the python struct
library docs}. The following are currently supported: \code{"xbBhHiIs"}.}

\item{conn}{a connection returned by \code{\link[base]{file}}.}

\item{endianness}{string; passed to \code{\link[base]{readBin}}. One of
\code{"big"} or \code{"little"}.}

\item{n}{integer; the number of records to read. Also passed to
\code{\link[base]{readBin}}. \strong{NOTE:} this argument is ignored if
\code{fmt = "I"}, due to the way unsigned integers have to be hacked
together.}

\item{...}{additional arguments to be passed to \code{\link[base]{readBin}}.}
}
\value{
a "scalar" value according to \code{fmt}.
}
\description{
This function is exported mainly for my own benefit, but maybe
  others will find it useful. It is written to bring the python syntax for
  binary file reading to R. See the source code of this package for usage
  examples.

  Note a limitation of this approach to binary file reading is that
  \emph{reading} and \emph{unpacking} are inseparable, which can cause
  headaches in some cases.
}

