% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePSData.R
\name{makePSData}
\alias{makePSData}
\alias{makeData}
\title{Create a survey data set manually}
\usage{
makePSData(n, count, type = c("P", "S"))
}
\arguments{
\item{n}{Either the number of groups of glass or the size of different groups
of glass.}

\item{count}{Either the number of people in the survey sample who had \eqn{n}{n}
groups of glass on their clothing, or the number of people who had a group of glass of
size \eqn{n}{n}.}

\item{type}{either \code{"P"} or \code{"S"}}
}
\value{
an object of type \code{psData}---see \code{\link{readData}} for more
details.
}
\description{
Create a survey data set from the command line rather than reading data in
from a file. This function is likely to be only useful where there are a very
small number of group sizes, or sizes of groups of glass.
}
\examples{
## recreate the data read in the readData example
p1 = makePSData(n = c(0, 1, 2), count = c(98, 1, 1), type = "P")
s1 = makePSData(n = 1:3, count = c(1, 1, 1), type = "S")
p1
s1

}
\seealso{
readData
}
