% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{Male_Children}
\alias{Male_Children}
\title{Male children data}
\format{A data frame with 2 columns and 13 rows.
\describe{
\item{\code{No_of_Males}}{No of Male children among first 12 children of family size 13}
\item{\code{freq}}{Observed frequencies for corresponding male children}
}}
\source{
Extracted from

Borges, P., Rodrigues, J., Balakrishnan, N. and Bazan, J., 2014. A COM-Poisson type
generalization of the binomial distribution and its properties and applications.
Statistics & Probability Letters, 87, pp.158-166.

Available at: \url{http://conteudo.icmc.usp.br/CMS/Arquivos/arquivos_enviados/BIBLIOTECA_113_NSE_90.pdf}
}
\usage{
Male_Children
}
\description{
The number of male children among the first 12 children of family size 13 in 6115 families taken
from the hospital records in the nineteenth century Saxony (Sokal & Rohlf(1994), Lindsey (1995),
p. 59). The thirteenth child is ignored to assuage the effect of families non-randomly stopping
when a desired gender is reached.
}
\examples{
Male_Children$No_of_Males   # extracting the binomial random variables
sum(Male_Children$freq)     # summing all the frequencies

}
\keyword{datasets}
