% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit_internal_functions.R
\name{rm_empty_block}
\alias{rm_empty_block}
\title{Remove rows where all specified variables are missing}
\usage{
rm_empty_block(.data, ...)
}
\arguments{
\item{.data}{Dataframe.}

\item{...}{Unquoted variable/column names.}
}
\value{
Data frame.
}
\description{
It is common to want to remove cases/rows where all variables in a particular set are missing, 
e.g. all symptom variables are missing in a health care dataset.
}
\examples{
# Pretend that we want to remove rows that are missing in group1, group2, and group3 
# but keep rest of dataset. 
colon_s \%>\% 
  dplyr::mutate(
    group1 = rep(c(NA, 1), length.out = 929),
    group2 = rep(c(NA, 1), length.out = 929),
	 group3 = rep(c(NA, 1), length.out = 929)
  ) \%>\% 
rm_empty_block(group1, group2, group3) \%>\% 
  head()
}
