% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{loglikMaltipooCollapsed}
\alias{loglikMaltipooCollapsed}
\alias{gradMaltipooCollapsed}
\alias{hessMaltipooCollapsed}
\title{Calculations for the Collapsed Maltipoo Model}
\usage{
loglikMaltipooCollapsed(Y, upsilon, Theta, X, KInv, U, eta, ell, sylv = FALSE)

gradMaltipooCollapsed(Y, upsilon, Theta, X, KInv, U, eta, ell, sylv = FALSE)

hessMaltipooCollapsed(Y, upsilon, Theta, X, KInv, U, eta, ell, sylv = FALSE)
}
\arguments{
\item{Y}{D x N matrix of counts}

\item{upsilon}{(must be > D)}

\item{Theta}{D-1 x Q matrix the prior mean for regression coefficients}

\item{X}{Q x N matrix of covariates}

\item{KInv}{D-1 x D-1 symmetric positive-definite matrix}

\item{U}{a PQxQ matrix of stacked variance components}

\item{eta}{matrix (D-1)xN of parameter values at which to calculate quantities}

\item{ell}{P-vector of scale factors for each variance component (aka VCScale)}

\item{sylv}{(default:false) if true and if N < D-1 will use sylvester determinant
identity to speed computation}
}
\value{
see below
  \itemize{
    \item loglikMaltipooCollapsed - double
    \item gradMaltipooCollapsed - vector
    \item hessMaltipooCollapsed- matrix
  }
}
\description{
Functions providing access to the Log Likelihood, Gradient, and Hessian
of the collapsed maltipoo model. Note: These are convenience functions
but are not as optimized as direct coding of the MaltipooCollapsed
C++ class due to a lack of Memoization. By contrast function optimMaltipooCollapsed
is much more optimized and massively cuts down on repeated calculations.
A more efficient Rcpp module based implementation of these functions
may following if the future. For model details see \code{\link{optimMaltipooCollapsed}}
documentation
}
