% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_mean}
\alias{view_on_mean}
\alias{view_on_mean.default}
\alias{view_on_mean.matrix}
\alias{view_on_mean.xts}
\alias{view_on_mean.tbl_df}
\title{Views on Expected Returns}
\usage{
view_on_mean(x, mean)

\method{view_on_mean}{default}(x, mean)

\method{view_on_mean}{matrix}(x, mean)

\method{view_on_mean}{xts}(x, mean)

\method{view_on_mean}{tbl_df}(x, mean)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{mean}{A \code{double} for the target location parameter of the series in \code{x}.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct views on expected returns.
}
\examples{
library(ggplot2)

# Invariant
ret <- diff(log(EuStockMarkets))
n   <- nrow(ret)

# Prior beliefs for expected returns (here is 2\% for each asset)
mean <- rep(0.02, 4)

# Prior probabilities (usually equal weight scheme)
prior <- rep(1 / n, n)

# View
views <- view_on_mean(x = ret, mean = mean)
views

# Optimization
ep <- entropy_pooling(p = prior, Aeq = views$Aeq, beq = views$beq, solver = "nlminb")
autoplot(ep)

# Probabilities are twisted in such a way that the posterior
# `mu` match's exactly with previously stated beliefs
ffp_moments(x = ret, p = ep)$mu
}
