% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_rank}
\alias{view_on_rank}
\alias{view_on_rank.default}
\alias{view_on_rank.matrix}
\alias{view_on_rank.xts}
\alias{view_on_rank.tbl_df}
\title{Views on Relative Performance}
\usage{
view_on_rank(x, rank)

\method{view_on_rank}{default}(x, rank)

\method{view_on_rank}{matrix}(x, rank)

\method{view_on_rank}{xts}(x, rank)

\method{view_on_rank}{tbl_df}(x, rank)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{rank}{A \code{double} with the asset indexes.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct views on relative performance of assets.
}
\details{
If \code{rank = c(2, 1)} it is implied that asset 1 will outperform asset 2.
For vectors of bigger size the interpretation is the same: assets on the right will outperform
assets on the left.
}
\examples{
library(ggplot2)

# Invariants
x <- diff(log(EuStockMarkets))
prior <- rep(1 / nrow(x), nrow(x))

# asset in the first col will outperform the asset in the second col.
views <- view_on_rank(x = x, rank = c(2, 1))
views

ep <- entropy_pooling(p = prior, A = views$A, b = views$b, solver = "solnl")
autoplot(ep)

# Prior Returns (SMI > DAX)
colMeans(x)[1:2]

# Posterior Returns (DAX > SMI)
ffp_moments(x, ep)$mu[1:2]
}
