% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_theo}
\alias{get_theo}
\title{Extract the theoretical best basis, if applicable}
\usage{
get_theo(dt)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}
}
\value{
a tibble object containing the theoretical bases
}
\description{
Extract the theoretical best basis, if applicable
}
\examples{
best <- matrix(c(0, 1, 0, 0, 0), nrow = 5)
holes_1d_better \%>\%
  bind_theoretical(best, tourr::holes(), raw_data = boa5) \%>\%
  get_theo()
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp_last}()},
\code{\link{get_interp}()},
\code{\link{get_interrupt}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()}
}
\concept{get functions}
