% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_search_count}
\alias{get_search_count}
\title{Extract the count in each iteration}
\usage{
get_search_count(dt, iter = NULL, group = NULL)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{iter}{the variable to be counted by}

\item{group}{the variable to label different runs of the optimiser(s)}
}
\value{
a tibble object of the number of searches conducted by the optimiser(s) in each iteration
}
\description{
Extract the count in each iteration
}
\examples{
get_search_count(holes_1d_better)
get_search_count(dplyr::bind_rows(holes_1d_better, holes_1d_geo), group = method)
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp_last}()},
\code{\link{get_interp}()},
\code{\link{get_interrupt}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
