\name{1D-models}
\alias{read.o2}
\alias{plot.o2}
\alias{print.o2}

\title{Models with 1 spatial dimension}
\description{Output from models having a spatial dimension can be read
  and visualized}
  
}
\usage{
read.o2(o2file)

plot.o2(x,zvari=1,col=topo.colors(100),nlevels=10,
        xlab="Time",ylab="Depth",rev="",xlim=NULL,
        ylim=NULL,labcex=1.5,linecol=1,contour=TRUE,...)

}
\arguments{
  \item{o2file}{File ending in .o2 generated by FEMME}
  \item{x}{object of class o2 created by \code{read.o2}}
  \item{zvari}{Index of Z Variable, or string with variable name}
  \item{rev}{Reversion of axis}
  \item{xlab}{X axis label}
  \item{ylab}{Y axis label}
  \item{xlim}{Limits of the X axis}
  \item{ylim}{Limits of the Y axis}
  \item{col}{Color palette}
  \item{nlevels}{Number of contour lines}
  \item{labcex}{Size of contour line labels}
  \item{linecol}{Color of contour lines}
  \item{contour}{Logical to plot contour lines}
  \item{...}{Additional plot parameters}
}
\details{Details can be found by typing vignette("femmeR")
}

\value{
\code{read.o2} returns a list with components
\item{data}{Modelled data}
\item{depth}{Depths of the data}
\item{time}{Times of the data}
}
\references{Soetaert et al, 2002}
\author{Henrik Andersson <h.andersson@nioo.knaw.nl>}
\note{Use at your own risk}
\examples{
## For examples see: vignette("femmeR")
}
\keyword{file}
\keyword{misc}
\keyword{hplot}

