% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksamp_perm_plot.R
\name{perm.plot}
\alias{perm.plot}
\title{Plot partial p-values}
\usage{
perm.plot(p, k, lab = NULL, save = FALSE, name = "pvalues.eps")
}
\arguments{
\item{p}{Output of function perm.test, if part = TRUE.}

\item{k}{Number of groups, must be greater than 2.}

\item{lab}{Group labels. Defaults to 1, 2, ..., k.}

\item{save}{Boolean variable that indicates if the plot must be saved as an .eps. Defaults to FALSE.}

\item{name}{If \code{save} is TRUE, this is the filename of the plot. Defaults to \code{pvalues.eps}.}
}
\value{
\code{perm.plot} plots the partial p-values in a matrix.
}
\description{
\code{perm.plot} plots all of the partial comparison p-values in a matrix.
}
\examples{
\dontrun{
## Phoneme data

library(fdcov)
library(fds)

# Create data set
data(aa); data(ao); data(dcl);data(iy);data(sh)
dat=cbind(aa$y[,1:20],ao$y[,1:20],dcl$y[,1:20],iy$y[,1:20],sh$y[,1:20])
dat=t(dat)
grp=c(rep(1,20),rep(2,20),rep(3,20),rep(4,20),rep(5,20))

# Test the equality of the covariance operators
p=ksample.perm(dat,grp,iter=100,only.glob=FALSE)

# Plot partial p-values
perm.plot(p,5, lab=c('aa','ao','dcl','iy','sh'))
}

}
\references{
Pigoli, Davide, John A. D. Aston, Ian L. Dryden, and Piercesare Secchi (2014). "Distances and inference for covariance operators." Biometrika: 101(2):409–422.
}
\author{
Alessandra Cabassi \email{alessandra.cabassi@mail.polimi.it}
}
