% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksamp_asymp.R
\name{ksample.vstab}
\alias{ksample.vstab}
\title{k-sample test for equality of covariance operators}
\usage{
ksample.vstab(dat1, dat2, K = 5)
}
\arguments{
\item{dat1}{the first set of data with one entry per row}

\item{dat2}{the second set of data with one entry per row}

\item{K}{the number of basis vectors to use, Default is 5.}
}
\value{
p-value testing whether or not the two samples have
differing covariance operators.
}
\description{
\code{ksample.gauss} performs a k-sample test for equality
of covariance operators under the assumption that the
data arises from a Gaussian process.
}
\details{
\code{ksample.vstab} applies a similar method that has
been modified to stabilize the variance.  See the reference
paper for more details on the mathematics of these methods.

These two methods use the Karhunen-Loeve expansion
(eigen expansion for functional data) to represent
the data in terms of K eigen-functions.  Then a
test statistic with asymptotic chi-squared distribution
is computed in order to test for the equality of the
covariance operators based on the two samples.
If K is set to be 0, then the methods determine the
number of eigen-functions to retain.
}
\examples{
# Load in phoneme data
library(fds)
# Set up test data
dat1 = t(aa$y)[1:20,];
dat2 = t(sh$y)[1:20,];
dat3 = t(aa$y)[21:40,];
# Compare two disimilar phonemes
# Resulting in a small p-value
ksample.gauss(dat1,dat2,K=5);
ksample.vstab(dat1,dat2,K=5);
# Compare two sets of the same phonemes
# Resulting in a large p-value
ksample.gauss(dat1,dat3,K=5);
ksample.vstab(dat1,dat3,K=5);
}
\references{
Panaretos, Victor M., David Kraus, and John H. Maddocks.
"Second-order comparison of Gaussian random functions and the
geometry of DNA minicircles." Journal of the American Statistical
Association 105.490 (2010): 670-682.
}
\author{
Adam B Kashlak \email{kashlak@ualberta.ca}
}
