% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oldFCReg.R
\name{oldFCReg}
\alias{oldFCReg}
\title{Functional Principal Component Analysis Concurrent Regression with Functional dependent variable}
\usage{
oldFCReg(depVar, expVarScal = NULL, expVarFunc = NULL,
  regressionType = NULL, getFitted = TRUE, bwScalar = NULL,
  bwFunct = NULL, splineSmooth = FALSE, verbose = FALSE)
}
\arguments{
\item{depVar}{An FPCA object}

\item{expVarScal}{A data.frame holding scalar explanatory variables; NAs will be omitted internally.}

\item{expVarFunc}{A list holding the FPCA objects for each of the functional explanatory variables.}

\item{regressionType}{A string defining the type of regression to perform ('dense' or 'sparse'); (default : automatically determined based on 'depVar')}

\item{getFitted}{If TRUE append the fitted values to the return object}

\item{bwScalar}{The value of bandwidth to be used for all scalar/functional cross-covariances (default: automatically determined using GCV)}

\item{bwFunct}{The values of bandwiths to be used for all function/function cross-covariances (default: automatically determined using GCV)}

\item{splineSmooth}{Use thin-plate splines during the estimation of the cross-covariance (default: FALSE)}

\item{verbose}{If TRUE print out the bandwidth used during the GCV procedures of selecting them}

\item{...}{Additional arguments}
}
\description{
Functional concurrent regression for dense or sparse functional data. This method is kept only of compatibility purposes. Do not use.
}
\references{
\cite{Yao, F., Mueller, H.G., Wang, J.L. "Functional Linear Regression Analysis for Longitudinal Data." Annals of Statistics 33, (2005): 2873-2903.(Dense data)} 

\cite{Senturk, D., Nguyen, D.V. "Varying Coefficient Models for Sparse Noise-contaminated Longitudinal Data", Statistica Sinica 21(4), (2011): 1831-1856. (Sparse data)}
}

