% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_models.R
\name{plot_dtt}
\alias{plot_dtt}
\title{Plot Data from simulation models}
\usage{
plot_dtt(
  y,
  grid_points,
  p,
  true_outliers,
  show_legend,
  plot_title,
  title_cex,
  ylabel,
  xlabel,
  legend_pos = "bottomright"
)
}
\arguments{
\item{y}{A matrix of \eqn{n} observations by \eqn{p} domain points}

\item{grid_points}{A vector of the evaluation/domain points of \code{y}}

\item{p}{A value indicating the number of evaluation/domain points}

\item{true_outliers}{An integer vector indicating the indices of the
true outliers}

\item{show_legend}{A logical indicating whether to add legend to plot if \code{plot = TRUE}.}

\item{plot_title}{Title of plot if \code{plot} is \code{TRUE}}

\item{title_cex}{Numerical value indicating the size of the plot title relative to the device default.
Set to 1.5 by default. Ignored if \code{plot = FALSE}.}

\item{ylabel}{The label of the y-axis. Set to \code{""} by default.}

\item{xlabel}{The label of the x-axis if \code{plot = TRUE}. Set to
\code{"gridpoints"} by default.}

\item{legend_pos}{A character value indicating the position of the
legend. Can be one of \code{"bottomright"}, \code{"bottom"},
\code{"bottomleft"}, \code{"left"} \code{"topleft"}, \code{"top"},
\code{"topright"}, \code{"right"}, \code{""center}.}
}
\description{
Support function for plotting data generated by any of the simulation model
 functions \code{simulation_model1() - simulation_model9()}.
}
