% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2likert}
\alias{norm2likert}
\title{Convert normal to likert}
\usage{
norm2likert(x, prob, mu = mean(x), sd = stats::sd(x))
}
\arguments{
\item{x}{the normally distributed vector}

\item{prob}{a vector of probabilities}

\item{mu}{the mean of x (calculated from x if not given)}

\item{sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a specified distribution
}
\description{
Convert normal to likert
}
\examples{

x <- rnorm(10000)
y <- norm2likert(x, c(.1, .2, .35, .2, .1, .05))
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

y <- norm2likert(x, c(.4, .3, .2, .1))
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
