% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_loaders.R
\name{ImageDataLoaders_from_name_re}
\alias{ImageDataLoaders_from_name_re}
\title{ImageDataLoaders from name regex}
\usage{
ImageDataLoaders_from_name_re(
  path,
  fnames,
  pat,
  bs = 64,
  val_bs = NULL,
  shuffle_train = TRUE,
  device = NULL,
  item_tfms = NULL,
  batch_tfms = NULL,
  ...
)
}
\arguments{
\item{path}{The folder where to work}

\item{fnames}{folder names}

\item{pat}{an argument that requires regex}

\item{bs}{The batch size}

\item{val_bs}{The batch size for the validation DataLoader (defaults to bs)}

\item{shuffle_train}{If we shuffle the training DataLoader or not}

\item{device}{device name}

\item{item_tfms}{One or several transforms applied to the items before batching them}

\item{batch_tfms}{One or several transforms applied to the batches once they are formed}

\item{...}{additional parameters to pass}
}
\value{
None
}
\description{
Create from the name attrs of `fnames` in `path`s with re expression `pat`
}
\examples{

\dontrun{

URLs_PETS()

path = 'oxford-iiit-pet'

dls = ImageDataLoaders_from_name_re(
path, fnames, pat='(.+)_\\\\d+.jpg$',
item_tfms = RandomResizedCrop(460, min_scale=0.75), bs = 10,
batch_tfms = list(aug_transforms(size = 299, max_warp = 0),
                  Normalize_from_stats( imagenet_stats() )
),
device = 'cuda'
)

}

}
