% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatches.R
\name{getMatches}
\alias{getMatches}
\title{getMatches}
\usage{
getMatches(dfA, dfB, fl.out)
}
\arguments{
\item{dfA}{Dataset A - matched to Dataset B by \code{fastLink()}.}

\item{dfB}{Dataset B - matches to Dataset A by \code{fastLink()}.}

\item{fl.out}{Either the output from \code{fastLink()} or \code{matchesLink()}.}
}
\value{
\code{getMatches()} returns a list of two data frames:
\item{dfA.match}{A subset of \code{dfA} subsetted down to the successful matches.}
\item{dfB.match}{A subset of \code{dfB} subsetted down to the successful matches.}
}
\description{
Subset two data frames to the matches returned by \code{fastLink()}
or \code{matchesLink()}.
}
\examples{
\dontrun{
fl.out <- fastLink(dfA, dfB,
varnames = c("firstname", "lastname", "streetname", "birthyear"),
n.cores = 1)
ret <- getMatches(dfA, dfB, fl.out)
}
}
\author{
Ben Fifield  <benfifield@gmail.com>
}
