/*
 * Decompiled with CFR 0.152.
 */
package jfm.mou;

import jfm.model.Types;
import jfm.mou.MOUObjectParser;
import jfm.mou.ObjectiveU;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

public class ObjectiveUParser
extends MOUObjectParser {
    ObjectiveUParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("type", mandatoryAttribute);
        this.registerAttribute("min", optionalAttribute);
        this.registerAttribute("max", optionalAttribute);
        this.registerAttribute("x", optionalAttribute);
        this.registerAttribute("y", optionalAttribute);
        this.registerAttribute("weight", mandatoryAttribute);
        this.registerAttribute("units", mandatoryAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        try {
            Types.ObjectiveType type = Types.xmlToObjectiveType(this.getNamedAttribute("type"));
            double rw = Double.parseDouble(this.getNamedAttribute("weight"));
            String units = this.getNamedAttribute("units");
            ObjectiveU theObj = null;
            if (this.attributeHasValue("min") && this.attributeHasValue("max")) {
                double min = Double.parseDouble(this.getNamedAttribute("min"));
                double max = Double.parseDouble(this.getNamedAttribute("max"));
                theObj = new ObjectiveU(type, units, min, max, rw);
            } else {
                theObj = new ObjectiveU(type, units, 0.0, 0.0, rw);
                theObj.isCurved = true;
            }
            if (this.attributeHasValue("x") && this.attributeHasValue("y")) {
                String[] ystrs;
                String[] xstrs = this.getNamedAttribute("x").split(",");
                if (xstrs.length != (ystrs = this.getNamedAttribute("y").split(",")).length) {
                    throw new Error("x and y length mismatch");
                }
                double[] x = new double[xstrs.length];
                double[] y = new double[ystrs.length];
                for (int i = 0; i < xstrs.length; ++i) {
                    x[i] = Double.parseDouble(xstrs[i]);
                    y[i] = Double.parseDouble(ystrs[i]);
                }
                theObj.setCurve(x, y);
            }
            this.obj = theObj;
        }
        catch (XMLSyntaxException ex) {
            throw new XMLSyntaxException(ex.getLocalizedMessage());
        }
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        return "ObjectiveUParser";
    }

    public String parsesNode() {
        return "ObjectiveU";
    }

    public String toString() {
        return "ObjectiveU Parser";
    }
}

