% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_gnn.R
\name{train_gnn}
\alias{train_gnn}
\title{Train and Evaluate the Gated Neural Network (robust splits + safe ROC)}
\usage{
train_gnn(
  prepared_data,
  hyper_grid,
  num_repeats = 20,
  epochs = 300,
  output_dir = tempdir(),
  run_tuning = TRUE,
  best_params = NULL,
  save_outputs = FALSE,
  seed = NULL,
  verbose = FALSE,
  tune_repeats = NULL,
  tune_epochs = NULL
)
}
\arguments{
\item{prepared_data}{List from \code{prepare_data()} containing:
\itemize{
\item \code{X} (matrix/data.frame of numeric features)
\item \code{y} (numeric 0/1)
\item \code{group} (numeric codes for sensitive subgroup)
\item \code{feature_names} (character vector; optional)
\item \code{subject_ids} (vector; optional)
}}

\item{hyper_grid}{data.frame with columns: \code{lr}, \code{hidden_dim}, \code{dropout_rate}, \code{lambda}, \code{temperature}.}

\item{num_repeats}{Integer (>=1). Repeated train/test splits for the \strong{final} model (and for tuning if \code{tune_repeats} is not set).}

\item{epochs}{Integer (>=1). Training epochs per run for the \strong{final} model (and for tuning if \code{tune_epochs} is not set).}

\item{output_dir}{Directory to write csv/rds if \code{save_outputs = TRUE}. Defaults to \code{tempdir()}.}

\item{run_tuning}{Logical. If \code{TRUE}, runs a grid search using \code{hyper_grid} and picks best by mean AUC.}

\item{best_params}{data.frame/list with \code{lr}, \code{hidden_dim}, \code{dropout_rate}, \code{lambda}, \code{temperature} if \code{run_tuning = FALSE}.}

\item{save_outputs}{Logical. If \code{TRUE}, writes CSV/RDS outputs to \code{output_dir}. Default \code{FALSE}.}

\item{seed}{Optional integer seed to make data splits reproducible. If \code{NULL}, current RNG state is respected.}

\item{verbose}{Logical. Print progress messages. Default \code{FALSE}.}

\item{tune_repeats}{Integer (>=1). Repeats per combo \strong{during tuning only}. Defaults to \code{min(5, num_repeats)}.}

\item{tune_epochs}{Integer (>=1). Epochs per run \strong{during tuning only}. Defaults to \code{min(epochs, 100)}.}
}
\value{
A list with:
\itemize{
\item \code{final_results} (tibble: subjectid, true, prob, group, iteration)
\item \code{gate_weights} (tibble with gate probabilities & entropy per subject/iteration)
\item \code{expert_weights} (list of expert input-layer weight matrices per repeat)
\item \code{performance_summary} (tibble with AUC and Brier)
\item \code{aif360_data} (tibble for fairness metric tooling)
\item \code{tuning_results} (tibble or message when tuning skipped)
}
}
\description{
Trains a subgroup-aware gated neural network with a fairness-constrained loss,
optionally performs hyperparameter tuning with lightweight budgets, and returns
predictions, gate/expert weights, and summary metrics. Designed to be CRAN-safe:
\itemize{
\item No background installs, no saving unless requested
\item CPU-only torch, capped threads to avoid oversubscription
}
}
