% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{fsvsim}
\alias{fsvsim}
\title{Simulate data from a factor SV model}
\usage{
fsvsim(n = 1000, series = 10, factors = 1, facload = "dense",
  idipara, facpara, heteroskedastic = rep(TRUE, series + factors),
  df = Inf)
}
\arguments{
\item{n}{Length of the series to be generated.}

\item{series}{Number of component series \code{m}.}

\item{factors}{Number of factors \code{r}.}

\item{facload}{Can either be a matrix of dimension \code{m} times \code{r}
or one of the keywords "dense" and "sparse". If "dense" is chosen,
a (rather) dense lower triangular factor loadings matrix is randomly
generated. If "sparse" is chosen, a (rather) sparse lower triangular
factor loadings matrix is randomly generated.}

\item{idipara}{\emph{Optional} matrix of idiosyncratic SV parameters
to be used for simulation. Must have exactly three columns containing
the values of \code{mu}, \code{phi} and \code{sigma} for each
of \code{m} series, respectively. If omitted, plausible values are
generated.}

\item{facpara}{\emph{Optional} matrix of idiosyncratic SV parameters
to be used for simulation. Must have exactly two columns containing
the values of \code{phi} and \code{sigma} for each of \code{r} factors,
respectively. If omitted, plausible values are generated.}

\item{heteroskedastic}{Logical vector of length \code{m+r}. When
\code{TRUE}, time-varying volatilities are generated; when
\code{FALSE}, constant volatilities (equal to \code{mu}) are generated.}

\item{df}{If not equal to Inf, the factors are misspecified (come from
a t distribution instead of a Gaussian). Only used for testing.}
}
\value{
The value returned is a list object of class \code{fsvsim} holding
 \itemize{
 \item{y}{The simulated data, stored in a \code{n} times \code{m} matrix with
 colnames 'Sim1', 'Sim2', etc.}
 \item{fac}{The simulated factors, stored in a \code{r} times \code{r} matrix.}
 \item{facload}{Factor loadings matrix.}
 \item{facvol}{Latent factor log-variances for times 1 to \code{n}.}
 \item{facvol0}{Initial factor log-variances for time 0.}
 \item{facpara}{The parameters of the factor volatility processes.}
 \item{idivol}{Latent idiosyncratic log-variances for times 1 to \code{n}.}
 \item{idivol0}{Initial idiosyncratic log-variances for time 0.}
 \item{idipara}{The parameters of the idiosyncratic volatility
 processes.}
}
}
\description{
\code{fsvsim} generates simulated data from a factor SV model.
}
\note{
This object can be passed to many plotting functions to indicate
the data generating processes when visualizing results.
}
