% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_shape.R
\name{fabric_shape}
\alias{fabric_shape}
\title{Create shapes inside a canvas}
\usage{
fabric_shape(
  cid,
  cwidth = 800,
  cheight = 600,
  cfill = "#FFFFFF",
  shapeId,
  shape = "Rect",
  left = 100,
  top = 100,
  fill = "red",
  width = 200,
  height = 200,
  angle = 0,
  opacity = 1,
  strokecolor = "darkblue",
  strokewidth = 5,
  selectable = TRUE,
  isDrawingMode = FALSE,
  radius = NULL
)
}
\arguments{
\item{cid}{the id of the canvas element}

\item{cwidth}{the width of the canvas element. Defaults to 800}

\item{cheight}{the height of the canvas element. Defaults to 600}

\item{cfill}{the color of the canvas element}

\item{shapeId}{the id of the shape object}

\item{shape}{the shape of the object. Choices include 'Circle', 'Triangle' and 'Rect'. Defaults to 'Rect'}

\item{left}{the shape's position from the left relative to the canvas element. Defaults to 100}

\item{top}{the shape's position from the top relative to the canvas element. Defaults to 100}

\item{fill}{the color of the shape. Defaults to 'red'}

\item{width}{the width of the shape. Defaults to 200}

\item{height}{the height of the shape. Defaults to 200}

\item{angle}{the angle of rotation of the shape. Defaults to 0 (no rotation)}

\item{opacity}{the opacity of the shape (from 0 to 1). Defaults to 1}

\item{strokecolor}{the stroke color of the shape. Defaults to 'darkblue'}

\item{strokewidth}{the stroke width of the shape. Defaults to 5.}

\item{selectable}{logical. If TRUE, the user can modify interactively the shape's size, position and rotation. Defaults to TRUE}

\item{isDrawingMode}{logical. If TRUE, the user can draw inside the canvas element.}

\item{radius}{Mandatory if the chosen shape is a 'Circle'. Defaults to NULL}
}
\value{
a shape object inside a canvas
}
\description{
Create shapes inside a canvas
}
\examples{

if(interactive()){

ui <- fluidPage(

use_fabric(),

h2("Below you'll find a red Rectangle with a darkblue stroke"),

fabric_shape(cid = "canvas", shapeId = "shape1", shape = "Rect")

)

server <- function(input, output) {


}


shinyApp(ui = ui, server = server)

}

}
