% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_image.R
\name{fabric_image}
\alias{fabric_image}
\title{Insert external images inside canvas element}
\usage{
fabric_image(
  cid,
  cwidth = 800,
  cheight = 600,
  cfill = "#FFFFFF",
  imgId,
  imgsrc,
  imgwidth = 500,
  imgheight = 500,
  left = 100,
  top = 100,
  angle = 0,
  opacity = 1,
  strokecolor = "darkblue",
  strokewidth = 1,
  selectable = TRUE,
  isDrawingMode = FALSE
)
}
\arguments{
\item{cid}{the id of the canvas element}

\item{cwidth}{the width of the canvas element. Defaults to 800}

\item{cheight}{the height of the canvas element. Defaults to 600}

\item{cfill}{the color of the canvas element}

\item{imgId}{the id of the image}

\item{imgsrc}{the URL source of the image}

\item{imgwidth}{the width of the image. Defaults to 500}

\item{imgheight}{the height of the image. Defaults to 500}

\item{left}{the image's position from the left relative to the canvas element. Defaults to 100}

\item{top}{the image's position from the top relative to the canvas element. Defaults to 100}

\item{angle}{the angle of rotation of the image. Defaults to 0 (no rotation)}

\item{opacity}{the opacity of the image (from 0 to 1). Defaults to 1}

\item{strokecolor}{the stroke color of the image. Defaults to 'darkblue'}

\item{strokewidth}{the stroke width of the image. Defaults to 1}

\item{selectable}{logical. If TRUE, the user can modify interactively the image's size, position and rotation. Defaults to TRUE}

\item{isDrawingMode}{logical. If TRUE, the user can draw inside the canvas element.}
}
\value{
an image inside a canvas element
}
\description{
Insert external images inside canvas element
}
\examples{


if (interactive()) {

img <- "https://upload.wikimedia.org/wikipedia/commons/thumb/1/1b/R_logo.svg/724px-R_logo.svg.png"

ui <- fluidPage(

use_fabric(),

fabric_image(cid = "cimage",
             cfill = "lightblue",
             imgId = "Rimg",
             imgsrc = img)

             )

server <- function(input, output) {}


shinyApp(ui = ui, server = server)

}

}
