% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_helper.R
\name{set_eye_strings}
\alias{set_eye_strings}
\title{Set list of codes}
\usage{
set_eye_strings(
  right = c("r", "re", "od", "right"),
  left = c("l", "le", "os", "left"),
  both = c("b", "both", "ou"),
  iop = c("iop", "gat", "nct"),
  iop_partial = c("pressure"),
  va = c("va", "bcva"),
  va_method = c("etdrs", "snellen", "logmar"),
  va_partial = c("acuit"),
  id = c("pat", "id"),
  eye = c("eye", "eyes"),
  quali = c("nlp", "lp", "hm", "cf"),
  ...
)
}
\arguments{
\item{right}{right eyes}

\item{left}{left eyes}

\item{both}{both eyes}

\item{iop}{IOP codes}

\item{iop_partial}{partial strings used to find IOP columns}

\item{va}{VA codes}

\item{va_method}{VA methods (used to recognize VA columns -
when those strings occur "fully", i.e., not as part of sth else)}

\item{va_partial}{Also used to find VA columns - looking for partial strings}

\item{id}{patient column codes}

\item{eye}{eye column codes}

\item{quali}{quali VA codes}

\item{...}{currently not used, but might be needed in the future}
}
\description{
This sets the list of codes used throughout the eye package for
the coding of all kind of stuff. If you want to change recognized codes,
this is the place to do it. See examples below how to easily overwrite it.
It is important that you must pass them as a character vector!

\strong{cases are always ignored}, so you don't need to worry about this bit.
}
\examples{
# To expand recognized codes for eyes, e.g. if you want to use French names
set_eye_strings(right = c("droit", "od"), left = c("gauche", "og"))

# To restore the defaults, simply call set_eye_strings empty
set_eye_strings()
}
