% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{tidyNA}
\alias{tidyNA}
\alias{isNAstring}
\title{Tidy NA entries to actual NA values}
\usage{
tidyNA(x, ...)

isNAstring(x, string = NULL, defaultstrings = TRUE)
}
\arguments{
\item{x}{Vector}

\item{...}{passed to \link{isNAstring}}

\item{string}{vector of full strings to be replaced by NA}

\item{defaultstrings}{by default (TRUE), the following strings will be replaced by
NA values: c("\\.+", "", "\\s+", "n/a", "na", "null", "^-$").}
}
\value{
character vector
}
\description{
Creates tidy NA entries - NA equivalent strings are tidied to
actual NA values
}
\examples{
x <- c("a", "   ", ".", "-", "NULL")
tidyNA(x)

# in addition to the default strings, a new string can be added
tidyNA(x, string = "a")

# or just remove the strings you want
tidyNA(x, string = "a", defaultstrings = FALSE)
}
\keyword{internal}
