% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_pprtv.R
\name{extr_pprtv}
\alias{extr_pprtv}
\title{Extract Data from EPA PPRTVs}
\usage{
extr_pprtv(
  ids,
  search_type = "casrn",
  verbose = TRUE,
  force = TRUE,
  get_all = FALSE
)
}
\arguments{
\item{ids}{Character vector of identifiers to search (e.g., CASRN or chemical
names).}

\item{search_type}{Character string specifying the type of identifier:
"casrn" or "name". Default is "casrn". If \code{search_type} is "name", the
function performs a partial match search for the chemical name. NOTE:
Since partial mached is use, multiple seraches might match the same
chemical, therefore chemical ids might not be  uniques.}

\item{verbose}{Logical indicating whether to display progress messages.
Default is TRUE.}

\item{force}{Logical indicating whether to force a fresh download of the
database. Default is TRUE.}

\item{get_all}{Logical. If TRUE ignore all the other ignore \code{ids},
\code{search_type}, set  \code{force = TRUE} and get the all dataset.
This is was introduced for debugging purposes.}
}
\value{
A data frame with extracted information matching the specified
identifiers, or NULL if no matches are found.
}
\description{
Extracts data for specified identifiers (CASRN or chemical names) from the
EPA's Provisional Peer-Reviewed Toxicity Values (PPRTVs) database. The
function retrieves and processes data, with options to use cached files
or force a fresh download.
}
\examples{
\donttest{
condathis::with_sandbox_dir({ # this is to write on tempdir as for CRAN policies # nolint

  # Extract data for a specific CASRN
  Sys.sleep(4) # Sleep to avoid overwhelming the server
  extr_pprtv(ids = "107-02-8", search_type = "casrn", verbose = TRUE)

  Sys.sleep(4) # Sleep to avoid overwhelming the server
  # Extract data for a chemical name
  out <- extr_pprtv(
    ids = "Acrolein", search_type = "name", verbose = TRUE,
    force = TRUE
  )
  print(out)

  Sys.sleep(3) # Sleep to avoid overwhelming the server
  # Extract data for multiple identifiers
  out2 <- extr_pprtv(
    ids = c("107-02-8", "79-10-7", "42576-02-3"),
    search_type = "casrn",
    verbose = TRUE,
    force = TRUE
  )
  print(out2)
})
}
}
\seealso{
\href{https://www.epa.gov/pprtv/provisional-peer-reviewed-toxicity-values-pprtvs-assessments}{EPA PPRTVs} # nolint
}
