% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_vlines}
\alias{get_vlines}
\title{Prepare vertical lines}
\usage{
get_vlines(model, rl_index = NULL, mtbs = "verified")
}
\arguments{
\item{model}{An \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_Wisle}} object, i.e. a list returned
by the \code{\link{expirest_osle}()} or by the
\code{\link{expirest_wisle}()} function.}

\item{rl_index}{A positive integer that specifies which of the release limit
values that have been handed over to \code{\link{expirest_wisle}()} should
be displayed. The default is \code{NULL}.}

\item{mtbs}{A character string that specifies the \dQuote{model to be shown},
i.e. either \code{verified}, which is the default, or one of \code{cics},
\code{dics}, \code{dids} or \code{dids.pmse}. The \code{verified} model
is the model that was identified through the poolability check. It is
thus also one of the possible optional models. The \code{dids} model
represents the case where a separate model is fitted to the data of each
individual batch while the \code{dids.pmse} model is the interaction
model which includes the \eqn{batch} variable as main effect and in the
interaction term with the \eqn{time} variable (\eqn{batch \times time}),
i.e. a model where the mean square error is pooled across batches.}
}
\value{
A data frame with the columns \sQuote{Time}, Item, Colour and Type
is returned, where the column name \sQuote{Time} is a placeholder for the
corresponding variable name. If \code{model} is an \sQuote{expirest_osle}
object, the data frame has one row representing the POI obtained from
ordinary shelf life estimation. If \code{model} is an \sQuote{expirest_wisle}
object, the data frame has two rows representing the POI obtained from
ordinary shelf life estimation (row 1) and the POI of the What-if approach
for shelf life estimation (row 2).
}
\description{
The function \code{get_vlines()} prepares a data frame for putting
vertical lines on a plot prepared by the \code{ggplot()} function from
the \sQuote{\code{ggplot2}} package.
}
\details{
The function \code{get_vlines()} expects various pieces
of information characterising an \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_wisle}} model. Based on the information provided,
the function prepares a data frame that that is used by the functions
\code{\link{plot_expirest_osle}()} or \code{\link{plot_expirest_wisle}(}))
to put text annotations on the graph that is prepared by these functions.
}
\seealso{
\code{\link{plot_expirest_osle}}, \code{\link{plot_expirest_wisle}},
\code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{geom_text}}.
}
\keyword{internal}
