% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite_exclusions.R
\name{unite_exclusions}
\alias{unite_exclusions}
\title{Unite multiple exclusion columns into single column}
\usage{
unite_exclusions(
  x,
  exclusion_types = c("duplicates", "duration", "ip", "location", "preview",
    "progress", "resolution"),
  separator = ",",
  remove = TRUE
)
}
\arguments{
\item{x}{Data frame or tibble (preferably exported from Qualtrics).}

\item{exclusion_types}{Vector of types of exclusions to unite.}

\item{separator}{Character string specifying what character to use to
separate multiple exclusion types}

\item{remove}{Logical specifying whether to remove united columns
(default = TRUE) or leave them in the data frame (FALSE)}
}
\value{
An object of the same type as \code{x} that includes the all of the same
rows but with a single \code{exclusion} column replacing all of the specified
\verb{exclusion_*} columns.
}
\description{
Each of the \verb{mark_*()} functions appends a new column to the data.
The \code{unite_exclusions()} function unites all of those columns in a
single column that can be used to filter any or all exclusions downstream.
Rows with multiple exclusions are concatenated with commas.
}
\examples{

# Unite all exclusion types
df <- qualtrics_text \%>\%
  mark_duplicates() \%>\%
  mark_duration(min_duration = 100) \%>\%
  mark_ip() \%>\%
  mark_location() \%>\%
  mark_preview() \%>\%
  mark_progress() \%>\%
  mark_resolution()
df2 <- df \%>\%
  unite_exclusions()

# Unite subset of exclusion types
df2 <- df \%>\%
  unite_exclusions(exclusion_types = c("duplicates", "duration", "ip"))
}
\concept{helper}
