% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_LDB.R
\name{LDB}
\alias{LDB}
\title{Local Dependence Biclustering}
\usage{
LDB(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  ncls = 2,
  method = "R",
  conf = NULL,
  g_list = NULL,
  adj_list = NULL,
  adj_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{ncls}{number of latent class(rank). The default is 2.}

\item{method}{specify the model to analyze the data.Local dependence latent
class model is set to "C", latent rank model is set "R". The default is "R".}

\item{conf}{For the confirmatory parameter, you can input either a vector with
items and corresponding fields in sequence, or a field membership profile
matrix. In the case of the former, the field membership profile matrix will be generated internally.
When providing a membership profile matrix, it needs to be either matrix or data.frame.
The number of fields(nfld) will be overwrite to the number of columns of this matrix.}

\item{g_list}{A list compiling graph-type objects for each rank/class.}

\item{adj_list}{A list compiling matrix-type adjacency matrices for each rank/class.}

\item{adj_file}{A file detailing the relationships of the graph for each rank/class,
listed in the order of starting point, ending point, and rank(class).}

\item{verbose}{verbose output Flag. default is TRUE}
}
\value{
\describe{
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{Nclass}{Optimal number of classes.}
\item{Nfield}{Optimal number of fields.}
\item{crr}{Correct Response Rate}
\item{ItemLabel}{Label of Items}
\item{FieldLabel}{Label of Fields}
\item{adj_list}{List of Adjacency matrix used in the model}
\item{g_list}{List of graph object used in the model}
\item{IRP}{List of Estimated Parameters. This object is three-dimensional
PIRP array, where each dimension represents the number of rank,number
of field, and Dmax. Dmax denotes the maximum number of correct response
patterns for each field.}
\item{LFD}{Latent Field Distribution. see also \link{plot.exametrika}}
\item{LRD}{Latent Rank Distribution. see also \link{plot.exametrika}}
\item{FRP}{Marginal Field Reference Matrix}
\item{FRPIndex}{Index of FFP includes the item location parameters B and Beta,
the slope parameters A and Alpha, and the monotonicity indices C and Gamma.}
\item{CCRR_table}{This table is a rearrangement of IRP into a data.frame
format for output, consisting of combinations of rank ,field and PIRP.}
\item{TRP}{Test Reference Profile}
\item{RMD}{Rank Membership Distribution.}
\item{FieldEstimated}{Given vector which correspondence between items
and the fields.}
\item{ClassEstimated}{An index indicating which class a student belongs
to, estimated by confirmatory Ranklustering.}
\item{Students}{Rank Membership Profile matrix.The s-th row vector of \eqn{\hat{M}_R}, \eqn{\hat{m}_R}, is the
rank membership profile of Student s, namely the posterior probability distribution representing the student's
belonging to the respective latent classes. It also includes the rank with the maximum estimated membership probability,
as well as the rank-up odds and rank-down odds.}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
}
}
\description{
Latent dependence Biclustering, which incorporates biclustering and a Bayesian
network model.
}
\examples{
\donttest{
# Example: Latent Dirichlet Bayesian Network model
# Create field configuration vector based on field assignments
conf <- c(
  1, 6, 6, 8, 9, 9, 4, 7, 7, 7, 5, 8, 9, 10, 10, 9, 9,
  10, 10, 10, 2, 2, 3, 3, 5, 5, 6, 9, 9, 10, 1, 1, 7, 9, 10
)

# Create edge data for the network structure between fields
edges_data <- data.frame(
  "From Field (Parent) >>>" = c(
    6, 4, 5, 1, 1, 4, # Class/Rank 2
    3, 4, 6, 2, 4, 4, # Class/Rank 3
    3, 6, 4, 1, # Class/Rank 4
    7, 9, 6, 7 # Class/Rank 5
  ),
  ">>> To Field (Child)" = c(
    8, 7, 8, 7, 2, 5, # Class/Rank 2
    5, 8, 8, 4, 6, 7, # Class/Rank 3
    5, 8, 5, 8, # Class/Rank 4
    10, 10, 8, 9 # Class/Rank 5
  ),
  "At Class/Rank (Locus)" = c(
    2, 2, 2, 2, 2, 2, # Class/Rank 2
    3, 3, 3, 3, 3, 3, # Class/Rank 3
    4, 4, 4, 4, # Class/Rank 4
    5, 5, 5, 5 # Class/Rank 5
  )
)

# Save edge data to temporary CSV file
tmp_file <- tempfile(fileext = ".csv")
write.csv(edges_data, file = tmp_file, row.names = FALSE)

# Fit Latent Dirichlet Bayesian Network model
result.LDB <- LDB(
  U = J35S515,
  ncls = 5, # Number of latent classes
  conf = conf, # Field configuration vector
  adj_file = tmp_file # Path to the CSV file
)

# Clean up temporary file
unlink(tmp_file)

# Display model results
print(result.LDB)

# Visualize different aspects of the model
plot(result.LDB, type = "Array") # Show bicluster structure
plot(result.LDB, type = "TRP") # Test Response Profile
plot(result.LDB, type = "LRD") # Latent Rank Distribution
plot(result.LDB,
  type = "RMP", # Rank Membership Profiles
  students = 1:9, nc = 3, nr = 3
)
plot(result.LDB,
  type = "FRP", # Field Reference Profiles
  nc = 3, nr = 2
)
# Field PIRP Profile showing correct answer counts for each rank and field
plot(result.LDB, type = "FieldPIRP")
}
}
