% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand.R
\name{plot_ts}
\alias{plot_ts}
\title{Plot a timeseries tibble in a Dygraphs HTML plot}
\usage{
plot_ts(
  df,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  group = NULL,
  legend_width = 250,
  ...
)
}
\arguments{
\item{df}{data.frame or tibble, first column of name \code{datetime} being of class datetime and rest of columns being numeric}

\item{title}{character, title of the plot (accepts HTML code)}

\item{xlab}{character, X axis label (accepts HTML code)}

\item{ylab}{character, Y axis label (accepts HTML code)}

\item{group}{character, dygraphs group to associate this plot with. The x-axis zoom level of dygraphs plots within a group is automatically synchronized.}

\item{legend_width}{integer, width (in pixels) of the div which shows the legend.}

\item{...}{extra arguments to pass to \code{dygraphs::dyOptions} function.}
}
\value{
dygraph
}
\description{
First column of the tibble must be a datetime or date variable.
The rest of columns must be numeric of the same units.
}
\examples{
suppressMessages(library(lubridate))
suppressMessages(library(dplyr))

# Get demand with the complete datetime sequence from the sessions
sessions <- head(evsim::california_ev_sessions, 100)
demand <- get_demand(
  sessions,
  by = "Session",
  resolution = 60,
  align_time = TRUE
)
demand \%>\% plot_ts()

}
