% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateHypotMatrix.R
\name{CreateHypotMatrix}
\alias{CreateHypotMatrix}
\title{Creates binary correlation matrices}
\usage{
CreateHypotMatrix(modularity.hypot)
}
\arguments{
\item{modularity.hypot}{Matrix of hypothesis. Each line represents a trait and each column a module.
if modularity.hypot[i,j] == 1, trait i is in module j.}
}
\value{
binary matrix or list of binary matrices. If a matrix is passed, all the vectors are combined in the 
last binary matrix (total hypothesis of full integration hypothesis).
}
\description{
Takes a binary vector or column matrix and generates list of binary correlation matrices representing
the partition in the vectors.
}
\examples{
rand.hypots <- matrix(sample(c(1, 0), 30, replace=TRUE), 10, 3)
CreateHypotMatrix(rand.hypots) 
}
