% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelativeEigenanalysis.R
\name{RelativeEigenanalysis}
\alias{RelativeEigenanalysis}
\title{Relative Eigenanalysis}
\usage{
RelativeEigenanalysis(cov.x, cov.y, symmetric = FALSE)
}
\arguments{
\item{cov.x}{covariance matrix}

\item{cov.y}{covariance matrix}

\item{symmetric}{compute symmetric eigenanalysis?}
}
\value{
list with two objects: eigenvalues and eigenvectors
}
\description{
Computes relative eigenvalues and eigenvectors between a pair of covariance matrices.
}
\examples{
data(dentus)
dentus.vcv <- dlply(dentus, .(species), function(df) var(df[, -5]))

dentus.eigrel <- RelativeEigenanalysis(dentus.vcv [[1]], dentus.vcv[[5]])

}
\references{
Bookstein, F. L., and P. Mitteroecker, P. "Comparing Covariance Matrices by
Relative Eigenanalysis, with Applications to Organismal Biology." Evolutionary Biology 41, no. 2
(June 1, 2014): 336-350. doi:10.1007/s11692-013-9260-5.
}
\author{
Guilherme Garcia, Diogo Melo
}
