% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fitmnormgpd.r
\name{fitmnormgpd}
\alias{fitmnormgpd}
\alias{litmnormgpd}
\alias{nleuitmnormgpd}
\alias{nlitmnormgpd}
\alias{nluitmnormgpd}
\alias{profleuitmnormgpd}
\alias{profluitmnormgpd}
\title{MLE Fitting of Normal Bulk and GPD Tail Interval Transition Mixture Model}
\usage{
fitmnormgpd(x, eseq = NULL, useq = NULL, fixedeu = FALSE,
  pvector = NULL, std.err = TRUE, method = "BFGS", control = list(maxit
  = 10000), finitelik = TRUE, ...)

litmnormgpd(x, nmean = 0, nsd = 1, epsilon = nsd, u = qnorm(0.9, nmean,
  nsd), sigmau = nsd, xi = 0, log = TRUE)

nlitmnormgpd(pvector, x, finitelik = FALSE)

profleuitmnormgpd(eu, pvector, x, method = "BFGS", control = list(maxit =
  10000), finitelik = FALSE, ...)

nleuitmnormgpd(pvector, epsilon, u, x, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{eseq}{vector of epsilons (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedeu}{logical, should threshold and epsilon be fixed
(at either scalar value in \code{useq} and \code{eseq},
or estimated from maximum of profile likelihood evaluated at
grid of thresholds and epsilons in \code{useq} and \code{eseq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{nmean}{scalar normal mean}

\item{nsd}{scalar normal standard deviation (positive)}

\item{epsilon}{interval half-width}

\item{u}{scalar threshold value}

\item{sigmau}{scalar scale parameter (positive)}

\item{xi}{scalar shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}

\item{eu}{vector of epsilon and threshold pair considered in profile likelihood}
}
\value{
Log-likelihood is given by \code{\link[evmix:fitmnormgpd]{litmnormgpd}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fitmnormgpd]{nlitmnormgpd}}
  and \code{\link[evmix:fitmnormgpd]{nluitmnormgpd}}. Profile likelihood for
  threshold and interval half-width given by \code{\link[evmix:fitmnormgpd]{profluitmnormgpd}}.
  Fitting function \code{\link[evmix:fitmnormgpd]{fitmnormgpd}} returns a simple list
  with the following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedeu}:   \tab fixed epsilon and threshold, logical\cr
 \code{useq}:      \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{eseq}:      \tab epsilon vector for profile likelihood or scalar for fixed epsilon\cr
 \code{nllheuseq}: \tab profile negative log-likelihood at each combination in (eseq, useq)\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{nmean}:     \tab MLE of normal shape\cr
 \code{nsd}:       \tab MLE of normal scale\cr
 \code{epsilon}:   \tab MLE of transition half-width\cr
 \code{u}:         \tab threshold (fixed or MLE)\cr
 \code{sigmau}:    \tab MLE of GPD scale\cr
 \code{xi}:        \tab MLE of GPD shape\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value
mixture model with the normal bulk and GPD tail interval transition mixture model.
With options for profile likelihood estimation for threshold and interval half-width,
which can both be fixed.
}
\details{
The extreme value mixture model with the normal bulk and GPD tail with interval
transition is fitted to the entire dataset using maximum likelihood estimation.
The estimated parameters, variance-covariance matrix and their standard errors are automatically
output.

See \code{\link[evmix:itmnormgpd]{ditmnormgpd}} for explanation of normal-GPD interval
transition model, including mixing functions.

See also help for \code{\link[evmix:fnormgpd]{fnormgpd}} for mixture model fitting details.
Only the different features are outlined below for brevity.

The full parameter vector is
(\code{nmean}, \code{nsd}, \code{epsilon}, \code{u}, \code{sigmau}, \code{xi})
if threshold and interval half-width are both estimated and
(\code{nmean}, \code{nsd}, \code{sigmau}, \code{xi})
for profile likelihood or fixed threshold and epsilon approach.

If the profile likelihood approach is used, then it is applied to both the threshold and
epsilon parameters together. A grid search over all combinations of epsilons and thresholds
are considered. The combinations which lead to less than 5 on either side of the interval are
not considered.

A fixed threshold and epsilon approach is acheived by setting a single scalar value to each in
\code{useq} and \code{eseq} respectively.

If the profile likelihood approach is used, then a grid search over all combinations of epsilon and threshold
are carried out. The combinations which lead to less than 5 in any any interval are not considered.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of normal parameters assuming entire population is normal; and
 \item epsilon is MLE of normal standard deviation;
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters above threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(1, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# MLE for complete parameter set
fit = fitmnormgpd(x)
hist(x, breaks = seq(-6, 6, 0.1), freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, ditmnormgpd(xx, nmean, nsd, epsilon, u, sigmau, xi), col="red"))
abline(v = fit$u + fit$epsilon * seq(-1, 1), col = "red")

# Profile likelihood for threshold which is then fixed
fitfix = fitmnormgpd(x, eseq = seq(0, 2, 0.1), useq = seq(0, 2.5, 0.1), fixedeu = TRUE)
with(fitfix, lines(xx, ditmnormgpd(xx, nmean, nsd, epsilon, u, sigmau, xi), col="blue"))
abline(v = fitfix$u + fitfix$epsilon * seq(-1, 1), col = "blue")
legend("topright", c("True Density", "normal-GPD ITM", "Profile likelihood"),
  col=c("black", "red", "blue"), lty = 1)
}
}
\author{
Alfadino Akbar and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Holden, L. and Haug, O. (2013). A mixture model for unsupervised tail
estimation. arxiv:0902.4137
}
\seealso{
\code{\link[evmix:fnormgpd]{fnormgpd}}, \code{\link[stats:Normal]{dnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}
}

