% Generated by roxygen2 (4.0.1): do not edit by hand
\name{gng}
\alias{dgng}
\alias{gng}
\alias{pgng}
\alias{qgng}
\alias{rgng}
\title{Normal Bulk with GPD Upper and Lower Tails Extreme Value Mixture Model}
\usage{
dgng(x, nmean = 0, nsd = 1, ul = qnorm(0.1, nmean, nsd), sigmaul = nsd,
  xil = 0, phiul = TRUE, ur = qnorm(0.9, nmean, nsd), sigmaur = nsd,
  xir = 0, phiur = TRUE, log = FALSE)

pgng(q, nmean = 0, nsd = 1, ul = qnorm(0.1, nmean, nsd), sigmaul = nsd,
  xil = 0, phiul = TRUE, ur = qnorm(0.9, nmean, nsd), sigmaur = nsd,
  xir = 0, phiur = TRUE, lower.tail = TRUE)

qgng(p, nmean = 0, nsd = 1, ul = qnorm(0.1, nmean, nsd), sigmaul = nsd,
  xil = 0, phiul = TRUE, ur = qnorm(0.9, nmean, nsd), sigmaur = nsd,
  xir = 0, phiur = TRUE, lower.tail = TRUE)

rgng(n = 1, nmean = 0, nsd = 1, ul = qnorm(0.1, nmean, nsd),
  sigmaul = nsd, xil = 0, phiul = TRUE, ur = qnorm(0.9, nmean, nsd),
  sigmaur = nsd, xir = 0, phiur = TRUE)
}
\arguments{
\item{ul}{lower tail threshold}

\item{sigmaul}{lower tail GPD scale parameter (positive)}

\item{xil}{lower tail GPD shape parameter}

\item{phiul}{probability of being below lower threshold \eqn{[0, 1]} or \code{TRUE}}

\item{ur}{upper tail threshold}

\item{sigmaur}{upper tail GPD scale parameter (positive)}

\item{xir}{upper tail GPD shape parameter}

\item{phiur}{probability of being above upper threshold \eqn{[0, 1]} or \code{TRUE}}

\item{nmean}{normal mean}

\item{nsd}{normal standard deviation (positive)}

\item{x}{quantiles}

\item{log}{logical, if TRUE then log density}

\item{q}{quantiles}

\item{lower.tail}{logical, if FALSE then upper tail probabilities}

\item{p}{cumulative probabilities}

\item{n}{sample size (positive integer)}
}
\value{
\code{\link[evmix:gng]{dgng}} gives the density,
\code{\link[evmix:gng]{pgng}} gives the cumulative distribution function,
\code{\link[evmix:gng]{qgng}} gives the quantile function and
\code{\link[evmix:gng]{rgng}} gives a random sample.
}
\description{
Density, cumulative distribution function, quantile function and
  random number generation for the extreme value mixture model with normal
  for bulk distribution between the upper and lower thresholds with
  conditional GPD's for the two tails. The parameters are the normal mean
  \code{nmean} and standard deviation \code{nsd}, lower tail (threshold \code{ul},
  GPD scale \code{sigmaul} and shape \code{xil} and tail fraction \code{phiul})
  and upper tail (threshold \code{ur}, GPD scale \code{sigmaur} and shape
  \code{xiR} and tail fraction \code{phiuR}).
}
\details{
Extreme value mixture model combining normal distribution for the bulk
between the lower and upper thresholds and GPD for upper and lower tails. The
user can pre-specify \code{phiul} and \code{phiur} permitting a parameterised
value for the lower and upper tail fraction respectively. Alternatively, when
\code{phiul=TRUE} or \code{phiur=TRUE} the corresponding tail fraction is
estimated as from the normal bulk model.

Notice that the tail fraction cannot be 0 or 1, and the sum of upper and lower tail
fractions \code{phiul+phiur<1}, so the lower threshold must be less than the upper,
\code{ul<ur}.

The cumulative distribution function now has three components. The lower tail with
tail fraction \eqn{\phi_{ul}} defined by the normal bulk model (\code{phiul=TRUE})
upto the lower threshold \eqn{x < u_l}:
  \deqn{F(x) = H(u_l) G_l(x).}
where \eqn{H(x)} is the normal cumulative distribution function (i.e.
\code{pnorm(ur, nmean, nsd)}). The
\eqn{G_l(X)} is the conditional GPD cumulative distribution function with negated
data and threshold, i.e. \code{dgpd(-x, -ul, sigmaul, xil, phiul)}. The normal
bulk model between the thresholds \eqn{u_l \le x \le u_r} given by:
\deqn{F(x) = H(x).}
Above the threshold \eqn{x > u_r} the usual conditional GPD:
\deqn{F(x) = H(u_r) + [1 - H(u_r)] G(x)}
where \eqn{G(X)}.

The cumulative distribution function for the pre-specified tail fractions
\eqn{\phi_{ul}} and \eqn{\phi_{ur}} is more complicated.  The unconditional GPD
is used for the lower tail \eqn{x < u_l}:
  \deqn{F(x) = \phi_{ul} G_l(x).}
The normal bulk model between the thresholds \eqn{u_l \le x \le u_r} given by:
\deqn{F(x) = \phi_{ul}+ (1-\phi_{ul}-\phi_{ur}) (H(x) - H(u_l)) / (H(u_r) - H(u_l)).}
Above the threshold \eqn{x > u_r} the usual conditional GPD:
\deqn{F(x) = (1-\phi_{ur}) + \phi_{ur} G(x)}
Notice that these definitions are equivalent when \eqn{\phi_{ul} = H(u_l)} and
\eqn{\phi_{ur} = 1 - H(u_r)}.

See \code{\link[evmix:gpd]{gpd}} for details of GPD upper tail component,
\code{\link[stats:Normal]{dnorm}} for details of normal bulk component and
\code{\link[evmix:normgpd]{dnormgpd}} for normal with GPD extreme value
mixture model.
}
\note{
All inputs are vectorised except \code{log} and \code{lower.tail}.
The main input (\code{x}, \code{p} or \code{q}) and parameters must be either
a scalar or a vector. If vectors are provided they must all be of the same length,
and the function will be evaluated for each element of vector. In the case of
\code{\link[evmix:gng]{rgng}} any input vector must be of length \code{n}.

Default values are provided for all inputs, except for the fundamentals
\code{x}, \code{q} and \code{p}. The default sample size for
\code{\link[evmix:gng]{rgng}} is 1.

Missing (\code{NA}) and Not-a-Number (\code{NaN}) values in \code{x},
\code{p} and \code{q} are passed through as is and infinite values are set to
\code{NA}. None of these are not permitted for the parameters.

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\examples{
\dontrun{
par(mfrow=c(2,2))
x = rgng(1000, phiul = 0.15, phiur = 0.15)
xx = seq(-6, 6, 0.01)
hist(x, breaks = 100, freq = FALSE, xlim = c(-6, 6))
lines(xx, dgng(xx, phiul = 0.15, phiur = 0.15))

# three tail behaviours
plot(xx, pgng(xx), type = "l")
lines(xx, pgng(xx, xil = 0.3, xir = 0.3), col = "red")
lines(xx, pgng(xx, xil = -0.3, xir = -0.3), col = "blue")
legend("topleft", paste("Symmetric xil=xir=",c(0, 0.3, -0.3)),
  col=c("black", "red", "blue"), lty = 1)

x = rgng(1000, xil = -0.3, phiul = 0.2, xir = 0.3, phiur = 0.2)
xx = seq(-6, 6, 0.01)
hist(x, breaks = 100, freq = FALSE, xlim = c(-6, 6))
lines(xx, dgng(xx, xil = -0.3, phiul = 0.2, xir = 0.3, phiur = 0.2))

plot(xx, dgng(xx, xil = -0.3, phiul = 0.2, xir = 0.3, phiur = 0.2), type = "l", ylim = c(0, 0.4))
lines(xx, dgng(xx, xil = -0.3, phiul = 0.3, xir = 0.3, phiur = 0.3), col = "red")
lines(xx, dgng(xx, xil = -0.3, phiul = TRUE, xir = 0.3, phiur = TRUE), col = "blue")
legend("topleft", c("phiul = phiur = 0.2", "phiul = phiur = 0.3", "Bulk Tail Fraction"),
  col=c("black", "red", "blue"), lty = 1)
}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Zhao, X., Scarrott, C.J. Reale, M. and Oxley, L. (2010). Extreme value modelling
for forecasting the market crisis. Applied Financial Econometrics 20(1), 63-72.
}
\seealso{
\code{\link[evmix:gpd]{gpd}} and \code{\link[stats:Normal]{dnorm}}

Other normgpd normgpdcon gng gngcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}};
  \code{\link{ditmgng}}, \code{\link{ditmgng}},
  \code{\link{ditmgng}}, \code{\link{ditmgng}},
  \code{\link{ditmgng}}, \code{\link{itmgng}},
  \code{\link{itmgng}}, \code{\link{itmgng}},
  \code{\link{itmgng}}, \code{\link{itmgng}},
  \code{\link{pitmgng}}, \code{\link{pitmgng}},
  \code{\link{pitmgng}}, \code{\link{pitmgng}},
  \code{\link{pitmgng}}, \code{\link{qitmgng}},
  \code{\link{qitmgng}}, \code{\link{qitmgng}},
  \code{\link{qitmgng}}, \code{\link{qitmgng}},
  \code{\link{ritmgng}}, \code{\link{ritmgng}},
  \code{\link{ritmgng}}, \code{\link{ritmgng}},
  \code{\link{ritmgng}}; \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}};
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}; \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}};
  \code{\link{fgng}}, \code{\link{fgng}},
  \code{\link{fgng}}, \code{\link{fgng}},
  \code{\link{fgng}}, \code{\link{lgng}},
  \code{\link{lgng}}, \code{\link{lgng}},
  \code{\link{lgng}}, \code{\link{lgng}},
  \code{\link{nlgng}}, \code{\link{nlgng}},
  \code{\link{nlgng}}, \code{\link{nlgng}},
  \code{\link{nlgng}}, \code{\link{nlugng}},
  \code{\link{nlugng}}, \code{\link{nlugng}},
  \code{\link{nlugng}}, \code{\link{nlugng}},
  \code{\link{proflugng}}, \code{\link{proflugng}},
  \code{\link{proflugng}}, \code{\link{proflugng}},
  \code{\link{proflugng}}; \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{nleuitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{profleuitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}};
  \code{\link{fnormgpdcon}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpdcon}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{lnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{lnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{nlunormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{nlunormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}}; \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}}
}

