% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking.r
\name{checking}
\alias{checking}
\alias{check.quant}
\alias{check.prob}
\alias{check.n}
\alias{check.param}
\alias{check.posparam}
\alias{check.nparam}
\alias{check.logic}
\alias{check.text}
\alias{check.inputn}
\alias{check.param}
\alias{check.posparam}
\alias{check.quant}
\alias{check.prob}
\alias{check.n}
\alias{check.logic}
\alias{check.nparam}
\alias{check.inputn}
\alias{check.text}
\alias{check.phiu}
\alias{check.optim}
\alias{check.control}
\alias{check.bcmethod}
\alias{check.nn}
\alias{check.offset}
\alias{check.design.knots}
\title{Internal functions for checking function input arguments}
\usage{
check.param(param, allowvec = FALSE, allownull = FALSE, allowmiss = FALSE,
  allowna = FALSE, allowinf = FALSE)

check.posparam(param, allowvec = FALSE, allownull = FALSE,
  allowmiss = FALSE, allowna = FALSE, allowinf = FALSE,
  allowzero = FALSE)

check.quant(x, allownull = FALSE, allowna = FALSE, allowinf = FALSE)

check.prob(prob, allownull = FALSE, allowna = FALSE)

check.n(n, allowzero = FALSE)

check.logic(logicarg, allowvec = FALSE, allowna = FALSE)

check.nparam(ns, nparam = 1, allownull = FALSE, allowmiss = FALSE)

check.inputn(inputn, allowscalar = FALSE, allowzero = FALSE)

check.text(textarg, allowvec = FALSE, allownull = FALSE)

check.phiu(phiu, allowvec = FALSE, allownull = FALSE, allowfalse = FALSE)

check.optim(method)

check.control(control)

check.bcmethod(bcmethod)

check.nn(nn)

check.offset(offset, bcmethod, allowzero = FALSE)

check.design.knots(beta, xrange, nseg, degree, design.knots)
}
\arguments{
\item{param}{scalar or vector of parameters}

\item{allowvec}{logical, where TRUE permits vector}

\item{allownull}{logical, where TRUE permits NULL values}

\item{allowmiss}{logical, where TRUE permits missing input}

\item{allowna}{logical, where TRUE permits NA and NaN values}

\item{allowinf}{logical, where TRUE permits +/-Inf values}

\item{allowzero}{logical, where TRUE permits zero values (positive vs non-negative)}

\item{x}{scalar or vector of quantiles}

\item{prob}{scalar or vector of probability}

\item{n}{scalar sample size}

\item{logicarg}{logical input argument}

\item{ns}{vector of lengths of parameter vectors}

\item{nparam}{acceptable length of (non-scalar) vectors of parameter vectors}

\item{inputn}{vector of input lengths}

\item{allowscalar}{logical, where TRUE permits scalar (as opposed to vector) values}

\item{textarg}{character input argument}

\item{phiu}{scalar or vector of phiu (logical, NULL or 0-1 exclusive)}

\item{allowfalse}{logical, where TRUE permits FALSE (and TRUE) values}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{bcmethod}{boundary correction method}

\item{nn}{non-negativity correction method (simple boundary correction only)}

\item{offset}{offset added to kernel centres (logtrans only) or \code{NULL}}

\item{beta}{vector of B-spline coefficients (required)}

\item{xrange}{vector of minimum and maximum of B-spline (support of density)}

\item{nseg}{number of segments between knots}

\item{degree}{degree of B-splines (0 is constant, 1 is linear, etc.)}

\item{design.knots}{spline knots for splineDesign function}
}
\value{
The checking functions will stop on errors and return no value. The only exception is
the \code{\link[evmix:checking]{check.inputn}} which outputs the maximum vector length.
}
\description{
Functions for checking the input arguments to functions, so that main functions
are more concise. They will stop when an inappropriate input is found.

These function are visible and operable by the user. But they should be used with caution, as no
checks on the input validity are carried out.

For likelihood functions you will often not want to stop on finding a non-positive values for
positive parameters, in such cases use \code{\link[evmix:checking]{check.param}} rather than 
\code{\link[evmix:checking]{check.posparam}}.
}
\author{
Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}.
}
