% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{logLik.evgam}
\alias{logLik.evgam}
\title{Log-likelihood, AIC and BIC from a fitted \code{evgam} object}
\usage{
\method{logLik}{evgam}(object, ...)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{...}{not used}
}
\value{
A scalar
}
\description{
Log-likelihood, AIC and BIC from a fitted \code{evgam} object
}
\examples{

data(fremantle)
fmla_gev <- list(SeaLevel ~ s(Year, k=5, bs="cr"), ~ 1, ~ 1)
m_gev <- evgam(fmla_gev, fremantle, family = "gev")
logLik(m_gev)
AIC(m_gev)
BIC(m_gev)

}
