% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEvent.R
\name{predictEvent}
\alias{predictEvent}
\title{Predict event}
\usage{
predictEvent(
  df = NULL,
  target_d,
  newSubjects = NULL,
  event_fit,
  dropout_fit = NULL,
  fixedFollowup = FALSE,
  followupTime = 365,
  pilevel = 0.9,
  nreps = 500,
  showplot = TRUE
)
}
\arguments{
\item{df}{The subject-level enrollment and event data,
including \code{randdt}, \code{cutoffdt},
\code{time}, \code{event}, and \code{dropout}. By default, it
is set to \code{NULL} for event prediction at the design stage.}

\item{target_d}{The target number of events to reach in the study.}

\item{newSubjects}{The enrollment data for new subjects. By default,
it is set to \code{NULL}, indicating the completion of
subject enrollment.}

\item{event_fit}{The pre-fitted event model used to generate
predictions.}

\item{dropout_fit}{The pre-fitted dropout model used to generate
predictions. By default, it is set to \code{NULL},
indicating no dropout.}

\item{fixedFollowup}{A Boolean variable indicating whether a fixed
follow-up design is used. By default, it is set to \code{FALSE}
for a variable follow-up design.}

\item{followupTime}{The follow-up time for a fixed
follow-up design, in days. By default, it is set to 365.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}

\item{showplot}{A Boolean variable to control whether or not
the prediction plot is displayed. By default, it is set to
\code{TRUE}.}
}
\value{
A list of prediction results which includes important
information such as the median, lower and upper percentiles for
the estimated time and date to reach the target number of events,
as well as simulated event data for both ongoing and new subjects.
Additionally, the data for the prediction plot is also included
within this list.
}
\description{
Utilizes pre-fitted time-to-event and time-to-dropout models
to generate event and dropout times for ongoing subjects
and new subjects. It also provides a
prediction interval for the expected time to reach the target
number of events.
}
\details{
To ensure successful event prediction at the design stage, it is
important to provide the \code{newSubjects} data set.

To specify the event model used during the design-stage event
prediction, the \code{event_fit} list should include the event model,
\code{model}, the number of treatment groups,
\code{ngroups}, the randomization probabilities for each group,
\code{prob}, the model parameters, \code{theta},
and the covariance matrix, \code{vtheta}, both of which
have \code{ngroups} blocks with the \code{j}-th block
specifying the prior distribution of model
parameters for the \code{j}-th treatment group. For the
piecewise exponential event model, \code{knots} should also
be included to indicate the location of inner knots.
It should be noted that the model averaging option is not
appropriate for use during the design stage.

To specify the dropout model used during the design stage
event prediction, the \code{dropout_fit} list should include
the dropout model, \code{model}, the number of treatment groups,
\code{ngroups}, the randomization probabilities for each
group, \code{prob}, the model parameters, \code{theta}, and
the covariance matrix ,\code{vtheta}, both of which have
\code{ngroups} blocks with the \code{j}-th block specifying
the prior distribution of model parameters for the
\code{j}-th treatment group.
}
\examples{

# Event prediction after enrollment completion

event_fit <- fitEvent(df = observedData,
                      event_model = "piecewise exponential", npieces = 3)

dropout_fit <- fitDropout(df = observedData,
                          dropout_model = "exponential")

event_pred <- predictEvent(df = observedData, target_d = 200,
                           event_fit = event_fit,
                           dropout_fit = dropout_fit,
                           pilevel = 0.90, nreps = 200)

}
