% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_geo_code.R
\name{harmonize_geo_code}
\alias{harmonize_geo_code}
\title{Harmonize NUTS region codes that changed with the \code{NUTS2016} definition}
\usage{
harmonize_geo_code(dat)
}
\arguments{
\item{dat}{A Eurostat data frame downloaded with \code{\link{get_eurostat}}}
}
\value{
An augmented data frame that explains potential problems and 
possible solutions.
}
\description{
Eurostat mixes \code{NUTS2013} and \code{NUTS2016} geographic
label codes in the \code{'geo'} column, which creates time-wise comparativity issues.
This function checks if you data is affected by this problem and gives
information on what to do.
}
\examples{
 \dontrun{
   dat <- eurostat::tgs00026
   harmonize_geo_code(dat)
 }
 
}
\author{
Daniel Antal
}
