% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_eurostat_geodata.R
\name{merge_eurostat_geodata}
\alias{merge_eurostat_geodata}
\title{Merge Preprocessed Geospatial Data from CISGO with data_frame from Eurostat}
\usage{
merge_eurostat_geodata(data, geocolumn = "geo", resolution = "60",
  output_class = "df", all_regions = FALSE, cache = TRUE,
  update_cache = FALSE, cache_dir = NULL)
}
\arguments{
\item{data}{A data_frame including a character vector that
consists of values following current NUTS classification}

\item{geocolumn}{A string. Name of the column with NUTS information 
(\code{geo} in data_frames fetched using \code{get_eurostat})}

\item{resolution}{Resolution of the geospatial data. One of "60" (1:60million), "20" (1:20million), "10" (1:10million), "01" (1:1million),}

\item{output_class}{A string. Class of object returned, either \code{df} (\code{data_frame}) or \code{spdf} (\code{SpatialPolygonDataFrame})}

\item{all_regions}{Logical. To include all the regions from spatial data or only the ones included in the fetched Eurostat attribute data}

\item{cache}{cache. Logical.}

\item{update_cache}{Update cache. Logical.}

\item{cache_dir}{Cache directory.}
}
\value{
a data_frame or SpatialPolygonDataFrame.
}
\description{
Merges data_frame obtained from Eurostat with \code{get_eurostat} with geospatial data preprocessed either using \code{ggplot2::fortify} into a \code{data_frame} or a regular \code{SpatialPolygonDataFrame}. The resulting \code{data_frame} can be plotted using \code{ggplot2} and \code{SpatialPolygonDataFrame} using \code{sp::spplot}.
}
\examples{
 \dontrun{
   lp <- get_eurostat("nama_aux_lp")
   lpl <- merge_eurostat_geodata(lp, geocolumn="geo", resolution=60,
     	                    output_class="df", all_regions=FALSE)
   str(lpl)
 }
 
}
\author{
Markus Kainu <markuskainu@gmail.com>
}

