% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_spheric_proj.R
\name{mesh.spheric.proj}
\alias{mesh.spheric.proj}
\title{Adding spherical coordinates to a mesh}
\usage{
mesh.spheric.proj(mesh, verbose = TRUE)
}
\arguments{
\item{mesh}{"mesh" class object.}

\item{verbose}{Boolean, by default set to \code{FALSE}. Allows you to inhibit
comments.}
}
\value{
returns a "mesh" class object in which \code{$mesh} contains \code{Lat}
and \code{lon} evaluated at vertices.
The function allows to have a parameterized surface  for later computations
as curvature or shape index, hence, nor the surface, nor the angles are preserved.
In the DICOM frame of reference, latitude goes along Z axis (from feet = -1 to
head = +1) and longitude turns counter clockwise (from -1 to +1).
}
\description{
The \code{mesh.spheric.proj} function adds latitude and longitude
coordinates to a mesh. These features map the mesh surface to a sphere.
Latitude and longitude are computed using the heat diffusion approach explained by
\emph{Brechbühler and al} \strong{[1]}.
}
\note{
This funtion is time consuming.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 5
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

#creation of the patient mesh
bin <- bin.from.roi (CT, struct = S, roi.name = "patient", verbose = FALSE)
m.patient <- mesh.from.bin (bin)
m.skin <- mesh.repair (m.patient, verbose = FALSE)

m.proj <- mesh.spheric.proj (m.skin, verbose = FALSE)

library (rgl)
col <- hcl.colors (12, "Blue-Red 3")
open3d()
shade3d (m.proj$mesh, meshColors = "vertices",
         color = col[round ((m.proj$mesh$Lat/2 + 0.5) * 11) + 1],
         specular = "#404040")
open3d()         
shade3d (m.proj$mesh, meshColors = "vertices",
         color = col[round ((m.proj$mesh$Lon/2 + 0.5) * 11) + 1],
         specular = "#404040")

}
\references{
\strong{[1]} \insertRef{BRECHBUHLER1995154}{espadon}
}
