% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nesting_bin.R
\name{nesting.bin}
\alias{nesting.bin}
\title{Restrict volume to a binary selection}
\usage{
nesting.bin(
  vol,
  sel.bin,
  alias = "",
  description = NULL,
  xyz.margin = c(0, 0, 0)
)
}
\arguments{
\item{vol}{"volume" class object, containing data to restrict.}

\item{sel.bin}{"volume" class object, of "binary" modality, specifying the selected voxels.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.
If \code{description = NULL}, it will be
\code{paste (vol$description,"restricted to", sel.bin$description)}.}

\item{xyz.margin}{Vector of length 3, representing the distances in mm to be added
to the x, y and z directions of the rectangular parallelepiped circumscribed
to the voxels selected in \code{sel.bin}, in the cutting planes frame of reference.
By default xyz.margin = c (0, 0, 0).}
}
\value{
Returns a "volume" class object, in which 3D volume is limited to the
rectangular parallelepiped circumscribed to the voxels selected by \code{sel.bin}, increased by the
requested margins.
}
\description{
The \code{nesting.bin} function restricts a "volume" class
object to the rectangular parallelepiped circumscribed to the selected voxels.
}
\examples{
# loading of toy-patient objects (decrease dxyz for  better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct"), 
                             roi.name = "brain", dxyz = rep (step, 3))
CT <- patient$ct[[1]]
b <- bin.from.vol (CT, min = 0, max =200)

CT.restricted <- nesting.bin (CT, b, xyz.margin =  rep (step, 3))
display.plane (bottom = CT.restricted, top = b, view.type = "sagi",
             bottom.col = pal.RVV (1000),
             bottom.breaks = seq (-1000, 1000, length.out = 1001),
             bg = "#00ff00",  interpolate  = FALSE)
}
