% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_value_from_xyz.R
\name{get.value.from.xyz}
\alias{get.value.from.xyz}
\title{Voxel values on a selection of points}
\usage{
get.value.from.xyz(
  xyz,
  vol,
  xyz.ref.pseudo = NULL,
  T.MAT = NULL,
  interpolate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{xyz}{Vector of length 3, corresponding to the x, y, z
coordinates (in mm) of a point in \code{xyz.ref.pseudo} frame of
reference, or 3-column matrix of x, y, z coordinates of several points.}

\item{vol}{"volume" class object.}

\item{xyz.ref.pseudo}{\code{ref.pseudo} in which the \code{xyz}
coordinate points are given. This \code{ref.pseudo} must exist in the \code{T.MAT}
list. If \code{ref.pseudo} is \code{NULL} then the point with coordinates xyz
is considered to be in the patient frame of reference \code{vol$ref.pseudo}.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm},
\link[espadon]{load.patient.from.dicom} or \link[espadon]{load.T.MAT}. If
\code{T.MAT = NULL}, \code{xyz.ref.pseudo} must be equal to \code{vol$ref.pseudo}
or \code{NULL}.}

\item{interpolate}{Boolean, default to \code{FALSE}. If \code{interpolate = TRUE}, a
trilinear interpolation of the value of the voxels, relative to the values of
adjacent voxels, is performed.}

\item{verbose}{Boolean, default to \code{FALSE}. If \code{verbose = TRUE}, then
the xyz coordinates are printed.}
}
\value{
Returns a vector of the voxel values at the requested coordinates.
}
\description{
The \code{get.value.from.xyz} function calculates the voxel values at
the x, y, z coordinate points in the chosen frame of reference.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 4
patient <- toy.load.patient (modality = "rtdose", roi.name = "", 
                             dxyz = rep (step, 3), beam.nb = 3)
D <- patient$rtdose[[1]]
get.value.from.xyz (xyz = matrix (c (0, 0, 0, 10, 10, 10), 
                    ncol = 3, byrow = TRUE), vol = D)

# isodose
Dmax <- max (D$vol3D.data, na.rm = TRUE)
idx <- which (D$vol3D.data >= (Dmax -1) & D$vol3D.data <= (Dmax - 0.3))
pt <- get.xyz.from.index (idx, D)
get.value.from.xyz (pt, vol = D, interpolate = FALSE, verbose = TRUE)
}
\seealso{
\link[espadon]{get.xyz.from.index}
}
