% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_stats.R
\name{signal_stats}
\alias{signal_stats}
\title{Calculate signal statistics}
\usage{
signal_stats(data, stats, range_f, res_psd = 1, dt, cut = TRUE)
}
\arguments{
\item{data}{\code{eseis} object, data set to be processed.}

\item{stats}{\code{Character} vector, keywords of statistics to be 
calculated. If omitted, all statistics will be calculated. Wrongly 
spelled keywords will be omitted without warning.}

\item{range_f}{\code{Numerical} vector of length two, range of the 
frequency spectra used to calculate spectral properties. This is 
recommended to account for spurious or unwanted frequency pars, for 
example caused by ocean micro seism or high frequency effects.}

\item{res_psd}{\code{Numerical} value, resolution of the spectrogram
used to calculate statistics, in seconds. Default is \code{1} sec. The 
spectrogram will be calculated with 90 % overlap and smoothened by a 
running window of 5 sec.}

\item{dt}{\code{Numeric} value, sampling period. If omitted, \code{dt} 
is set to 1/200.}

\item{cut}{\code{Logical} value, option to cut output vector to the 
required statistics, instead of returning the full length of statistics, 
filled with NA values where no statistic was calculated. Default is 
\code{TRUE}.}
}
\value{
\code{data frame} with calculated statsitics
}
\description{
This function calculates a set of statistics for the seismic signal 
submitted.
}
\details{
Available statistics keywords are:
- (1) `"t_duration"` (Duration of the signal)
- (2) `"f_rise"` (Signal rise time, time from start to maximum amplitude)
- (3) `"f_fall"` (Signal fall time, tme from maximum amplitude to end)
- (4) `"t_risefall"` (Ratio of rise to fall time)
- (5) `"a_skewness"` (Skewness of the signal amplitude, see \code{seewave::specprop})
- (6) `"a_kurtosis"` (Kurtosis of the signal amplitude, see \code{seewave::specprop})
- (7) `"a1_kurtosis"` (Kurtosis of the filtered (0.1-1 Hz) signal amplitude, see \code{seewave::specprop})
- (8) `"a2_kurtosis"` (Kurtosis of the filtered (1-3 Hz) signal amplitude, see \code{seewave::specprop})
- (9) `"a3_kurtosis"` (Kurtosis of the filtered (3-10 Hz) signal amplitude, see \code{seewave::specprop})
- (10) `"a4_kurtosis"` (Kurtosis of the filtered (10-20 Hz) signal amplitude, see \code{seewave::specprop})
- (11) `"a5_kurtosis"` (Kurtosis of the filtered (20-50 Hz) signal amplitude, see \code{seewave::specprop})
- (12) `"e_maxmean"` (Ratio of maximum and mean envelope value, see Hibert et al. (2017))
- (13) `"e_maxmedian"` (Ratio of maximum and median envelope value, see Hibert et al. (2017))
- (14) `"e_skewness"` (Skewness of the signal envelope, see \code{seewave::specprop})
- (15) `"e_kurtosis"` (Kurtosis of the signal envelope, see \code{seewave::specprop})
- (16) `"e1_logsum"` (Logarithm of the filtered (0.1-1 Hz) envelope sum, see Hibert et al. (2017))
- (17) `"e2_logsum"` (Logarithm of the filtered (1-3 Hz) envelope sum, see Hibert et al. (2017))
- (18) `"e3_logsum"` (Logarithm of the filtered (3-10 Hz) envelope sum, see Hibert et al. (2017))
- (19) `"e4_logsum"` (Logarithm of the filtered (10-20 Hz) envelope sum, see Hibert et al. (2017))
- (20) `"e5_logsum"` (Logarithm of the filtered (20-50 Hz) envelope sum, see Hibert et al. (2017))
- (21) `"e_rmsdecphaseline"` (RMS of envelope from linear decrease, see Hibert et al. (2017))
- (22) `"c_peaks"` (Number of peaks (excursions above 75 % of the maximum) in signal cross correlation function, see Hibert et al. (2017))
- (23) `"c_energy1"` (Sum of the first third of the signal cross correlation function, see Hibert et al. (2017))
- (24) `"c_energy2"` (Sum of the last two thirds of the signal cross correlation function, see Hibert et al. (2017))
- (25) `"c_energy3"` (Ratio of c_energy1 and c_energy2, see Hibert et al. (2017))
- (26) `"s_peaks"` (Number of peaks (excursions above 75 % of the maximum) in spectral power, see Hibert et al. (2017))
- (27) `"s_peakpower"` (Mean power of spectral peaks, see Hibert et al. (2017))
- (28) `"s_mean"` (Mean spectral power, see Hibert et al. (2017))
- (29) `"s_median"` (Median spectral power, see Hibert et al. (2017))
- (30) `"s_max"` (Maximum spectral power, see Hibert et al. (2017))
- (31) `"s_var"` (Variance of the spectral power, see Hibert et al. (2017))
- (32) `"s_sd"` (Standard deviation of the spectral power, see \code{seewave::specprop})
- (33) `"s_sem"` (Standard error of the mean of the spectral power, see \code{seewave::specprop})
- (34) `"s_flatness"` (Spectral flatness, see \code{seewave::specprop})
- (35) `"s_entropy"` (Spectral entropy, see \code{seewave::specprop})
- (36) `"s_precision"` (Spectral precision, see \code{seewave::specprop})
- (37) `"s1_energy"` (Energy of the filtered (0.1-1 Hz) spectrum, see Hibert et al. (2017))
- (38) `"s2_energy"` (Energy of the filtered (1-3 Hz) spectrum, see Hibert et al. (2017))
- (39) `"s3_energy"` (Energy of the filtered (3-10 Hz) spectrum, see Hibert et al. (2017))
- (40) `"s4_energy"` (Energy of the filtered (10-20 Hz) spectrum, see Hibert et al. (2017))
- (41) `"s5_energy"` (Energy of the filtered (20-30 Hz) spectrum, see Hibert et al. (2017))
- (42) `"s_gamma1"` (Gamma 1, spectral centroid, see Hibert et al. (2017))
- (43) `"s_gamma2"` (Gamma 2, spectral gyration radius, see Hibert et al. (2017))
- (44) `"s_gamma3"` (Gamma 3, spectral centroid width, see Hibert et al. (2017))
- (45) `"f_modal"` (Modal frequency, see \code{seewave::specprop})
- (46) `"f_mean"` (Mean frequency (aka central frequency), see \code{seewave::specprop})
- (47) `"f_median"` (Median frequency, see \code{seewave::specprop})
- (48) `"f_q05"` (Quantile 0.05 of the spectrum, see \code{seewave::specprop})
- (49) `"f_q25"` (Quantile 0.25 of the spectrum, see \code{seewave::specprop})
- (50) `"f_q75"` (Quantile 0.75 of the spectrum, see \code{seewave::specprop})
- (51) `"f_q95"` (Quantile 0.95 of the spectrum, see \code{seewave::specprop})
- (52) `"f_iqr"` (Inter quartile range of the spectrum, see \code{seewave::specprop})
- (53) `"f_centroid"` (Spectral centroid, see \code{seewave::specprop})
- (54) `"p_kurtosismax"` (Kurtosis of the maximum spectral power over time, see Hibert et al. (2017))
- (55) `"p_kurtosismedian"` (Kurtosis of the median spectral power over time, see Hibert et al. (2017))
- (56) `"p_maxmean"` (Mean of the ratio of max to mean spectral power over time, see Hibert et al. (2017))
- (57) `"p_maxmedian"` (Mean of the ratio of max to median spectral power over time, see Hibert et al. (2017))
- (58) `"p_peaksmean"` (Number of peaks in normalised mean spectral power over time, see Hibert et al. (2017))
- (59) `"p_peaksmedian"` (Number of peaks in normalised median spectral power over time, see Hibert et al. (2017))
- (60) `"p_peaksmax"` (Number of peaks in normalised max spectral power over time, see Hibert et al. (2017))
- (61) `"p_peaksmaxmean"` (Ratio of number of peaks in normalised max and mean spectral power over time, see Hibert et al. (2017))
- (62) `"p_peaksmaxmedian"` (Ratio of number of peaks in normalised max and median spectral power over time, see Hibert et al. (2017))
- (63) `"p_peaksfcentral"` (Number of peaks in spectral power at central frequency over time, see Hibert et al. (2017))
- (64) `"p_diffmaxmean"` (Mean difference between max and mean power, see Hibert et al. (2017))
- (65) `"p_diffmaxmedian"` (Mean difference between max and median power, see Hibert et al. (2017))
- (66) `"p_diffquantile21"` (Mean difference between power quantiles 2 and 1, see Hibert et al. (2017))
- (67) `"p_diffquantile32"` (Mean difference between power quantiles 3 and 2, see Hibert et al. (2017))
- (68) `"p_diffquantile31"` (Mean difference between power quantiles 3 and 1, see Hibert et al. (2017))

References:
- Hibert C, Provost F, Malet J-P, Maggi A, Stumpf A, Ferrazzini V. 2017. 
Automatic identification of rockfalls and volcano-tectonic earthquakes
at the Piton de la Fournaise volcano using a Random Forest algorithm. 
Journal of Volcanology and Geothermal Research 340, 130-142.
}
\examples{

## load example data
data(rockfall)

## clip data to event of interest
eq <- signal_clip(data = rockfall_eseis, 
                  limits = as.POSIXct(c("2015-04-06 13:18:50",
                                        "2015-04-06 13:20:10"), 
                                      tz = "UTC"))

## calculate full statistics
eq_stats <- signal_stats(data = eq)

## show names of statistics
names(eq_stats)

## calculate and show selected statistics, with truncated frequency range
eq_stats_sub <- signal_stats(data = eq, 
                             stats = c("t_rise", 
                                       "c_peaks",
                                       "f_centroid"),
                             range_f = c(1, 90))
print(eq_stats_sub)

}
\author{
Michael Dietze
}
\keyword{eseis}
