% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialr_crm_selector.R
\name{get_trialr_crm_tite}
\alias{get_trialr_crm_tite}
\title{Get an object to fit the TITE-CRM model using the trialr package.}
\usage{
get_trialr_crm_tite(
  parent_selector_factory = NULL,
  skeleton,
  target,
  model,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just use CRM from the start.}

\item{skeleton}{Dose-toxicity skeleton, a non-decreasing vector of
probabilities.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{model}{character string identifying which model form to use. Options
include empiric, logistic, logistic2. The model form chosen determines which
prior hyperparameters are required. See \code{\link[trialr]{stan_crm}}
for more details.}

\item{...}{Extra args are passed to \code{\link[trialr]{stan_crm}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
CRM model to outcomes.
}
\description{
Get an object to fit the TITE-CRM model using the trialr package.
}
\details{
This function is a short-cut to \code{get_trialr_crm(tite = TRUE)}. See
\code{\link{get_trialr_crm}} for full details.
}
\examples{
# TODO
}
