% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demvn.R
\name{demvn}
\alias{demvn}
\title{Evaluate the density of a multivariate Gaussian fit}
\usage{
demvn(y, X, log = FALSE, verbose = TRUE, alpha = 2, beta = 1.25)
}
\arguments{
\item{y}{points at which the MVN is evaluated. It can be either a d-dimensional vector or an n by d matrix, 
each row indicating a different position.}

\item{X}{an n by d matrix containing the data.}

\item{log}{if TRUE the log-density is returned.}

\item{verbose}{currently not used.}

\item{alpha}{tuning parameter of \code{robCov}, see \code{?robCov} for details.}

\item{beta}{tuning parameter of \code{robCov}, see \code{?robCov} for details.}
}
\value{
A vector where the i-th entry is the density corresponding to the i-th row of y.
}
\description{
Given a sample X, it gives a pointwise evaluation of the multivariate normal (MVN) density fit at position y.
}
\details{
The covariance matrix is estimated robustly, using the \code{robCov} function.
}
\examples{
library(esaddle)
X <- matrix(rnorm(2 * 1e3), 1e3, 2) # Sample used to fit a multivariate Gaussian
demvn(rnorm(2), X, log = TRUE)      # Evaluate the fitted log-density at a random location
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com> and Simon N. Wood.
}
