% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-era_year.R
\name{era_year}
\alias{era_year}
\title{Year units}
\usage{
era_year(label = character(), days = 365.2425)
}
\arguments{
\item{label}{Character. Name of the year unit.}

\item{days}{Numeric. Average length of the year in solar days. Defaults to a
Gregorian year (365.2425 days).}
}
\value{
S3 vector of class \code{era_year}.
}
\description{
\code{era_year} objects describe the unit used for a year as its length in days.
This value is used in an era definition (\code{\link[=era]{era()}}) to enable conversions
between eras that use different units (with \code{\link[=yr_transform]{yr_transform()}}).
}
\examples{
era_year("Julian", 365.25)
}
\seealso{
Other era helper functions: 
\code{\link{era_parameters}},
\code{\link{era_year_parameters}},
\code{\link{era}},
\code{\link{is_era_year}()},
\code{\link{is_era}()},
\code{\link{is_yr}()},
\code{\link{this_year}()}
}
\concept{era helper functions}
