% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduler.R
\name{get_tasks}
\alias{get_tasks}
\title{Get the \code{\link{detect_loop}} task status}
\usage{
get_tasks(statuses = list())
}
\arguments{
\item{statuses}{Character vector for limiting the status of the returned tasks, default: list()}
}
\value{
A named list containing all necessary information to run and monitor the detect loop tasks.
}
\description{
Reads the status of the \code{\link{detect_loop}} tasks and updates it with changes requested by the Shiny app
}
\details{
After reading the tasks.json file and parsing it with jsonlite, this function will update the necessary fields in the 
tasks for executing and monitoring them.
}
\examples{
if(FALSE){
   #getting tasks statuses
   library(epitweetr)
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   tasks <- get_tasks()
}
}
\seealso{
\code{\link{download_dependencies}}

 \code{\link{update_geonames}}

 \code{\link{update_languages}}

 \code{\link{detect_loop}}
 
 \code{\link{geotag_tweets}}
 
 \code{\link{aggregate_tweets}}

 \code{\link{generate_alerts}}
}
