% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_effect.R
\name{matrix_effect}
\alias{matrix_effect}
\alias{matrix_effect.calibration}
\title{Assess matrix effects and matrix-matched calibrations}
\usage{
matrix_effect(object, ...)

\method{matrix_effect}{calibration}(object, ...)
}
\arguments{
\item{object}{an object of class '\code{\link{calibration}}'
obtained from analyzing standard solutions of different concentration
(solvent calibration data).}

\item{\dots}{additional objects of the same type obtained from
matrix-matched calibration data.}
}
\value{
The magnitude of a matrix effect is estimated by subtracting the slope of a
matrix-matched calibration from that of the solvent-based calibration. The
difference is divided by the slope of the solvent-based calibration.
}
\description{
Calculate the matrix effect by comparing the slope of a solvent-based
calibration curve with one or more matrix-matched calibration. The matrix
effect is expressed as signal suppression/enhancement ratio.
}
\details{
Matrix effects or signal suppression/enhancement ratios should be evaluated
during analytical method development to avoid over- or underestimation of
sample concentrations. In addition, signal suppression/enhancement ratios may
help to justify the validity of a regular solvent calibration as opposed to
matrix-matched calibrations. This may be the case if matrix effects or
signal suppression/enhancement ratios are close to measurement repeatability.
}
\examples{
data(din32645)
din <- calibration(Area ~ Conc, data = din32645)

m32645 <- din32645
m32645$Area <- din32645$Area * 1.5
matrix <- calibration(Area ~ Conc, data = m32645)

matrix_effect(din, matrix)

}
\seealso{
Other calibration: 
\code{\link{calibration}()},
\code{\link{din32645}},
\code{\link{icp}},
\code{\link{neitzel2003}},
\code{\link{weight_select}()}
}
\author{
Julius Albert, Zacharias Steinmetz
}
\concept{calibration}
