% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisdom.R
\name{bisdom}
\alias{bisdom}
\title{Categorize water drop penetration times}
\usage{
bisdom(wdpt, ...)
}
\arguments{
\item{wdpt}{a numeric vector containing WDPT measurement data in seconds}

\item{\dots}{arguments passed to \code{\link[base]{findInterval}}}
}
\description{
This wrapper function categorizes water drop penetration times (WDPT) [s] according to
the scale proposed by Bisdom et al. (1993).
}
\examples{
bisdom(c(2,6,20,NA,3,385))

}
\references{
Bisdom, E., Dekker, L., Schoute, J., 1993. Water Repellency of Sieve 
Fractions from Sandy Soils and Relationships with Organic Material and Soil 
Structure. Geoderma 56, 105–118. doi:10.1016/0016-7061(93)90103-R
}
\seealso{
\code{\link[base]{findInterval}} for the generic function.
}
